/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBExternalPermissions1Code;

@Validated
public class OBReadData1 {
    @JsonProperty(value="Permissions")
    @Valid
    private List<OBExternalPermissions1Code> permissions = new ArrayList<OBExternalPermissions1Code>();
    @JsonProperty(value="ExpirationDateTime")
    private DateTime expirationDateTime = null;
    @JsonProperty(value="TransactionFromDateTime")
    private DateTime transactionFromDateTime = null;
    @JsonProperty(value="TransactionToDateTime")
    private DateTime transactionToDateTime = null;

    public OBReadData1 permissions(List<OBExternalPermissions1Code> permissions) {
        this.permissions = permissions;
        return this;
    }

    public OBReadData1 addPermissionsItem(OBExternalPermissions1Code permissionsItem) {
        this.permissions.add(permissionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the Open Banking account access data types. This is a list of the data clusters being consented by the PSU, and requested for authorisation with the ASPSP.")
    @NotNull
    @Valid
    @Size(min=1)
    public List<OBExternalPermissions1Code> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<OBExternalPermissions1Code> permissions) {
        this.permissions = permissions;
    }

    public OBReadData1 expirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified date and time the permissions will expire. If this is not populated, the permissions will be open ended. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public OBReadData1 transactionFromDateTime(DateTime transactionFromDateTime) {
        this.transactionFromDateTime = transactionFromDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified start date and time for the transaction query period. If this is not populated, the start date will be open ended, and data will be returned from the earliest available transaction. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getTransactionFromDateTime() {
        return this.transactionFromDateTime;
    }

    public void setTransactionFromDateTime(DateTime transactionFromDateTime) {
        this.transactionFromDateTime = transactionFromDateTime;
    }

    public OBReadData1 transactionToDateTime(DateTime transactionToDateTime) {
        this.transactionToDateTime = transactionToDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified end date and time for the transaction query period. If this is not populated, the end date will be open ended, and data will be returned to the latest available transaction. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getTransactionToDateTime() {
        return this.transactionToDateTime;
    }

    public void setTransactionToDateTime(DateTime transactionToDateTime) {
        this.transactionToDateTime = transactionToDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadData1 obReadData1 = (OBReadData1)o;
        return Objects.equals(this.permissions, obReadData1.permissions) && Objects.equals(this.expirationDateTime, obReadData1.expirationDateTime) && Objects.equals(this.transactionFromDateTime, obReadData1.transactionFromDateTime) && Objects.equals(this.transactionToDateTime, obReadData1.transactionToDateTime);
    }

    public int hashCode() {
        return Objects.hash(this.permissions, this.expirationDateTime, this.transactionFromDateTime, this.transactionToDateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadData1 {\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("    transactionFromDateTime: ").append(this.toIndentedString(this.transactionFromDateTime)).append("\n");
        sb.append("    transactionToDateTime: ").append(this.toIndentedString(this.transactionToDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

