/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBReadDirectDebit1DataPreviousPaymentAmount;

@ApiModel(description="Account to or from which a cash entry is made.")
public class OBReadDirectDebit1DataDirectDebit {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="DirectDebitId")
    private String directDebitId = null;
    @JsonProperty(value="MandateIdentification")
    private String mandateIdentification = null;
    @JsonProperty(value="DirectDebitStatusCode")
    private DirectDebitStatusCodeEnum directDebitStatusCode = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="PreviousPaymentDateTime")
    private String previousPaymentDateTime = null;
    @JsonProperty(value="PreviousPaymentAmount")
    private OBReadDirectDebit1DataPreviousPaymentAmount previousPaymentAmount = null;

    public OBReadDirectDebit1DataDirectDebit accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBReadDirectDebit1DataDirectDebit directDebitId(String directDebitId) {
        this.directDebitId = directDebitId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="A unique and immutable identifier used to identify the direct debit resource. This identifier has no meaning to the account owner.")
    public String getDirectDebitId() {
        return this.directDebitId;
    }

    public void setDirectDebitId(String directDebitId) {
        this.directDebitId = directDebitId;
    }

    public OBReadDirectDebit1DataDirectDebit mandateIdentification(String mandateIdentification) {
        this.mandateIdentification = mandateIdentification;
        return this;
    }

    @NotNull
    @Size(min=1, max=35)
    @ApiModelProperty(required=true, value="Direct Debit reference. For AUDDIS service users provide Core Reference. For non AUDDIS service users provide Core reference if possible or last used reference.")
    public String getMandateIdentification() {
        return this.mandateIdentification;
    }

    public void setMandateIdentification(String mandateIdentification) {
        this.mandateIdentification = mandateIdentification;
    }

    public OBReadDirectDebit1DataDirectDebit directDebitStatusCode(DirectDebitStatusCodeEnum directDebitStatusCode) {
        this.directDebitStatusCode = directDebitStatusCode;
        return this;
    }

    @ApiModelProperty(value="Specifies the status of the direct debit in code form.")
    public DirectDebitStatusCodeEnum getDirectDebitStatusCode() {
        return this.directDebitStatusCode;
    }

    public void setDirectDebitStatusCode(DirectDebitStatusCodeEnum directDebitStatusCode) {
        this.directDebitStatusCode = directDebitStatusCode;
    }

    public OBReadDirectDebit1DataDirectDebit name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Size(min=1, max=70)
    @ApiModelProperty(required=true, value="Name of Service User.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBReadDirectDebit1DataDirectDebit previousPaymentDateTime(String previousPaymentDateTime) {
        this.previousPaymentDateTime = previousPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="Date of most recent direct debit collection.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public String getPreviousPaymentDateTime() {
        return this.previousPaymentDateTime;
    }

    public void setPreviousPaymentDateTime(String previousPaymentDateTime) {
        this.previousPaymentDateTime = previousPaymentDateTime;
    }

    public OBReadDirectDebit1DataDirectDebit previousPaymentAmount(OBReadDirectDebit1DataPreviousPaymentAmount previousPaymentAmount) {
        this.previousPaymentAmount = previousPaymentAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBReadDirectDebit1DataPreviousPaymentAmount getPreviousPaymentAmount() {
        return this.previousPaymentAmount;
    }

    public void setPreviousPaymentAmount(OBReadDirectDebit1DataPreviousPaymentAmount previousPaymentAmount) {
        this.previousPaymentAmount = previousPaymentAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadDirectDebit1DataDirectDebit obReadDirectDebit1DataDirectDebit = (OBReadDirectDebit1DataDirectDebit)o;
        return Objects.equals(this.accountId, obReadDirectDebit1DataDirectDebit.accountId) && Objects.equals(this.directDebitId, obReadDirectDebit1DataDirectDebit.directDebitId) && Objects.equals(this.mandateIdentification, obReadDirectDebit1DataDirectDebit.mandateIdentification) && Objects.equals((Object)this.directDebitStatusCode, (Object)obReadDirectDebit1DataDirectDebit.directDebitStatusCode) && Objects.equals(this.name, obReadDirectDebit1DataDirectDebit.name) && Objects.equals(this.previousPaymentDateTime, obReadDirectDebit1DataDirectDebit.previousPaymentDateTime) && Objects.equals(this.previousPaymentAmount, obReadDirectDebit1DataDirectDebit.previousPaymentAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.directDebitId, this.mandateIdentification, this.directDebitStatusCode, this.name, this.previousPaymentDateTime, this.previousPaymentAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadDirectDebit1DataDirectDebit {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    directDebitId: ").append(this.toIndentedString(this.directDebitId)).append("\n");
        sb.append("    mandateIdentification: ").append(this.toIndentedString(this.mandateIdentification)).append("\n");
        sb.append("    directDebitStatusCode: ").append(this.toIndentedString((Object)this.directDebitStatusCode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    previousPaymentDateTime: ").append(this.toIndentedString(this.previousPaymentDateTime)).append("\n");
        sb.append("    previousPaymentAmount: ").append(this.toIndentedString(this.previousPaymentAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DirectDebitStatusCodeEnum {
        ACTIVE("Active"),
        INACTIVE("Inactive");

        private String value;

        private DirectDebitStatusCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectDebitStatusCodeEnum fromValue(String text) {
            for (DirectDebitStatusCodeEnum b : DirectDebitStatusCodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

