/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBInterestFixedVariableType1Code;
import uk.org.openbanking.datamodel.account.OBOtherCodeType11;
import uk.org.openbanking.datamodel.account.OBOtherCodeType12;
import uk.org.openbanking.datamodel.account.OBReadProduct2DataOtherProductTypeCreditInterestOtherBankInterestType;

@ApiModel(description="Tier Band Details")
public class OBReadProduct2DataOtherProductTypeCreditInterestTierBand {
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="TierValueMinimum")
    private String tierValueMinimum = null;
    @JsonProperty(value="TierValueMaximum")
    private String tierValueMaximum = null;
    @JsonProperty(value="CalculationFrequency")
    private CalculationFrequencyEnum calculationFrequency = null;
    @JsonProperty(value="ApplicationFrequency")
    private ApplicationFrequencyEnum applicationFrequency = null;
    @JsonProperty(value="DepositInterestAppliedCoverage")
    private DepositInterestAppliedCoverageEnum depositInterestAppliedCoverage = null;
    @JsonProperty(value="FixedVariableInterestRateType")
    private OBInterestFixedVariableType1Code fixedVariableInterestRateType = null;
    @JsonProperty(value="AER")
    private String AER = null;
    @JsonProperty(value="BankInterestRateType")
    private BankInterestRateTypeEnum bankInterestRateType = null;
    @JsonProperty(value="BankInterestRate")
    private String bankInterestRate = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherBankInterestType")
    private OBReadProduct2DataOtherProductTypeCreditInterestOtherBankInterestType otherBankInterestType = null;
    @JsonProperty(value="OtherApplicationFrequency")
    private OBOtherCodeType11 otherApplicationFrequency = null;
    @JsonProperty(value="OtherCalculationFrequency")
    private OBOtherCodeType12 otherCalculationFrequency = null;

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for the Product.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand tierValueMinimum(String tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(-?\\\\d{1,14}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(required=true, value="Minimum deposit value for which the credit interest tier applies.")
    public String getTierValueMinimum() {
        return this.tierValueMinimum;
    }

    public void setTierValueMinimum(String tierValueMinimum) {
        this.tierValueMinimum = tierValueMinimum;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand tierValueMaximum(String tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
        return this;
    }

    @Pattern(regexp="^(-?\\\\d{1,14}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Maximum deposit value for which the credit interest tier applies.")
    public String getTierValueMaximum() {
        return this.tierValueMaximum;
    }

    public void setTierValueMaximum(String tierValueMaximum) {
        this.tierValueMaximum = tierValueMaximum;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand calculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
        return this;
    }

    @ApiModelProperty(value="How often is credit interest calculated for the account.")
    public CalculationFrequencyEnum getCalculationFrequency() {
        return this.calculationFrequency;
    }

    public void setCalculationFrequency(CalculationFrequencyEnum calculationFrequency) {
        this.calculationFrequency = calculationFrequency;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand applicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="How often is interest applied to the Product for this tier/band i.e. how often the financial institution pays accumulated interest to the customer's account.")
    public ApplicationFrequencyEnum getApplicationFrequency() {
        return this.applicationFrequency;
    }

    public void setApplicationFrequency(ApplicationFrequencyEnum applicationFrequency) {
        this.applicationFrequency = applicationFrequency;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand depositInterestAppliedCoverage(DepositInterestAppliedCoverageEnum depositInterestAppliedCoverage) {
        this.depositInterestAppliedCoverage = depositInterestAppliedCoverage;
        return this;
    }

    @ApiModelProperty(value="Amount on which Interest applied.")
    public DepositInterestAppliedCoverageEnum getDepositInterestAppliedCoverage() {
        return this.depositInterestAppliedCoverage;
    }

    public void setDepositInterestAppliedCoverage(DepositInterestAppliedCoverageEnum depositInterestAppliedCoverage) {
        this.depositInterestAppliedCoverage = depositInterestAppliedCoverage;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand fixedVariableInterestRateType(OBInterestFixedVariableType1Code fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBInterestFixedVariableType1Code getFixedVariableInterestRateType() {
        return this.fixedVariableInterestRateType;
    }

    public void setFixedVariableInterestRateType(OBInterestFixedVariableType1Code fixedVariableInterestRateType) {
        this.fixedVariableInterestRateType = fixedVariableInterestRateType;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand AER(String AER) {
        this.AER = AER;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(-?\\\\d{1,3}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(required=true, value="The annual equivalent rate (AER) is interest that is calculated under the assumption that any interest paid is combined with the original balance and the next interest payment will be based on the slightly higher account balance. Overall, this means that interest can be compounded several times in a year depending on the number of times that interest payments are made.  Read more: Annual Equivalent Rate (AER) http://www.investopedia.com/terms/a/aer.asp#ixzz4gfR7IO1A")
    public String getAER() {
        return this.AER;
    }

    public void setAER(String AER) {
        this.AER = AER;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand bankInterestRateType(BankInterestRateTypeEnum bankInterestRateType) {
        this.bankInterestRateType = bankInterestRateType;
        return this;
    }

    @ApiModelProperty(value="Interest rate types, other than AER, which financial institutions may use to describe the annual interest rate payable to the account holder's account.")
    public BankInterestRateTypeEnum getBankInterestRateType() {
        return this.bankInterestRateType;
    }

    public void setBankInterestRateType(BankInterestRateTypeEnum bankInterestRateType) {
        this.bankInterestRateType = bankInterestRateType;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand bankInterestRate(String bankInterestRate) {
        this.bankInterestRate = bankInterestRate;
        return this;
    }

    @Pattern(regexp="^(-?\\\\d{1,3}){1}(\\\\.\\\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Bank Interest for the product")
    public String getBankInterestRate() {
        return this.bankInterestRate;
    }

    public void setBankInterestRate(String bankInterestRate) {
        this.bankInterestRate = bankInterestRate;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand otherBankInterestType(OBReadProduct2DataOtherProductTypeCreditInterestOtherBankInterestType otherBankInterestType) {
        this.otherBankInterestType = otherBankInterestType;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBReadProduct2DataOtherProductTypeCreditInterestOtherBankInterestType getOtherBankInterestType() {
        return this.otherBankInterestType;
    }

    public void setOtherBankInterestType(OBReadProduct2DataOtherProductTypeCreditInterestOtherBankInterestType otherBankInterestType) {
        this.otherBankInterestType = otherBankInterestType;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand otherApplicationFrequency(OBOtherCodeType11 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBOtherCodeType11 getOtherApplicationFrequency() {
        return this.otherApplicationFrequency;
    }

    public void setOtherApplicationFrequency(OBOtherCodeType11 otherApplicationFrequency) {
        this.otherApplicationFrequency = otherApplicationFrequency;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBand otherCalculationFrequency(OBOtherCodeType12 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBOtherCodeType12 getOtherCalculationFrequency() {
        return this.otherCalculationFrequency;
    }

    public void setOtherCalculationFrequency(OBOtherCodeType12 otherCalculationFrequency) {
        this.otherCalculationFrequency = otherCalculationFrequency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadProduct2DataOtherProductTypeCreditInterestTierBand obReadProduct2DataOtherProductTypeCreditInterestTierBand = (OBReadProduct2DataOtherProductTypeCreditInterestTierBand)o;
        return Objects.equals(this.identification, obReadProduct2DataOtherProductTypeCreditInterestTierBand.identification) && Objects.equals(this.tierValueMinimum, obReadProduct2DataOtherProductTypeCreditInterestTierBand.tierValueMinimum) && Objects.equals(this.tierValueMaximum, obReadProduct2DataOtherProductTypeCreditInterestTierBand.tierValueMaximum) && Objects.equals((Object)this.calculationFrequency, (Object)obReadProduct2DataOtherProductTypeCreditInterestTierBand.calculationFrequency) && Objects.equals((Object)this.applicationFrequency, (Object)obReadProduct2DataOtherProductTypeCreditInterestTierBand.applicationFrequency) && Objects.equals((Object)this.depositInterestAppliedCoverage, (Object)obReadProduct2DataOtherProductTypeCreditInterestTierBand.depositInterestAppliedCoverage) && Objects.equals((Object)this.fixedVariableInterestRateType, (Object)obReadProduct2DataOtherProductTypeCreditInterestTierBand.fixedVariableInterestRateType) && Objects.equals(this.AER, obReadProduct2DataOtherProductTypeCreditInterestTierBand.AER) && Objects.equals((Object)this.bankInterestRateType, (Object)obReadProduct2DataOtherProductTypeCreditInterestTierBand.bankInterestRateType) && Objects.equals(this.bankInterestRate, obReadProduct2DataOtherProductTypeCreditInterestTierBand.bankInterestRate) && Objects.equals(this.notes, obReadProduct2DataOtherProductTypeCreditInterestTierBand.notes) && Objects.equals(this.otherBankInterestType, obReadProduct2DataOtherProductTypeCreditInterestTierBand.otherBankInterestType) && Objects.equals(this.otherApplicationFrequency, obReadProduct2DataOtherProductTypeCreditInterestTierBand.otherApplicationFrequency) && Objects.equals(this.otherCalculationFrequency, obReadProduct2DataOtherProductTypeCreditInterestTierBand.otherCalculationFrequency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identification, this.tierValueMinimum, this.tierValueMaximum, this.calculationFrequency, this.applicationFrequency, this.depositInterestAppliedCoverage, this.fixedVariableInterestRateType, this.AER, this.bankInterestRateType, this.bankInterestRate, this.notes, this.otherBankInterestType, this.otherApplicationFrequency, this.otherCalculationFrequency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadProduct2DataOtherProductTypeCreditInterestTierBand {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    tierValueMinimum: ").append(this.toIndentedString(this.tierValueMinimum)).append("\n");
        sb.append("    tierValueMaximum: ").append(this.toIndentedString(this.tierValueMaximum)).append("\n");
        sb.append("    calculationFrequency: ").append(this.toIndentedString((Object)this.calculationFrequency)).append("\n");
        sb.append("    applicationFrequency: ").append(this.toIndentedString((Object)this.applicationFrequency)).append("\n");
        sb.append("    depositInterestAppliedCoverage: ").append(this.toIndentedString((Object)this.depositInterestAppliedCoverage)).append("\n");
        sb.append("    fixedVariableInterestRateType: ").append(this.toIndentedString((Object)this.fixedVariableInterestRateType)).append("\n");
        sb.append("    AER: ").append(this.toIndentedString(this.AER)).append("\n");
        sb.append("    bankInterestRateType: ").append(this.toIndentedString((Object)this.bankInterestRateType)).append("\n");
        sb.append("    bankInterestRate: ").append(this.toIndentedString(this.bankInterestRate)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherBankInterestType: ").append(this.toIndentedString(this.otherBankInterestType)).append("\n");
        sb.append("    otherApplicationFrequency: ").append(this.toIndentedString(this.otherApplicationFrequency)).append("\n");
        sb.append("    otherCalculationFrequency: ").append(this.toIndentedString(this.otherCalculationFrequency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BankInterestRateTypeEnum {
        INBB("INBB"),
        INFR("INFR"),
        INGR("INGR"),
        INLR("INLR"),
        INNE("INNE"),
        INOT("INOT");

        private String value;

        private BankInterestRateTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static BankInterestRateTypeEnum fromValue(String text) {
            for (BankInterestRateTypeEnum b : BankInterestRateTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum DepositInterestAppliedCoverageEnum {
        INBA("INBA"),
        INTI("INTI"),
        INWH("INWH");

        private String value;

        private DepositInterestAppliedCoverageEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DepositInterestAppliedCoverageEnum fromValue(String text) {
            for (DepositInterestAppliedCoverageEnum b : DepositInterestAppliedCoverageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ApplicationFrequencyEnum {
        FQAT("FQAT"),
        FQDY("FQDY"),
        FQHY("FQHY"),
        FQMY("FQMY"),
        FQOT("FQOT"),
        FQQY("FQQY"),
        FQSD("FQSD"),
        FQWY("FQWY"),
        FQYY("FQYY");

        private String value;

        private ApplicationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ApplicationFrequencyEnum fromValue(String text) {
            for (ApplicationFrequencyEnum b : ApplicationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum CalculationFrequencyEnum {
        FQAT("FQAT"),
        FQDY("FQDY"),
        FQHY("FQHY"),
        FQMY("FQMY"),
        FQOT("FQOT"),
        FQQY("FQQY"),
        FQSD("FQSD"),
        FQWY("FQWY"),
        FQYY("FQYY");

        private String value;

        private CalculationFrequencyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CalculationFrequencyEnum fromValue(String text) {
            for (CalculationFrequencyEnum b : CalculationFrequencyEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

