/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBInterestCalculationMethod1Code;
import uk.org.openbanking.datamodel.account.OBOtherCodeType10;
import uk.org.openbanking.datamodel.account.OBReadProduct2DataOtherProductTypeCreditInterestTierBand;

@ApiModel(description="The group of tiers or bands for which credit interest can be applied.")
public class OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet {
    @JsonProperty(value="TierBandMethod")
    private TierBandMethodEnum tierBandMethod = null;
    @JsonProperty(value="CalculationMethod")
    private OBInterestCalculationMethod1Code calculationMethod = null;
    @JsonProperty(value="Destination")
    private DestinationEnum destination = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherCalculationMethod")
    private OBOtherCodeType10 otherCalculationMethod = null;
    @JsonProperty(value="OtherDestination")
    private OBOtherCodeType10 otherDestination = null;
    @JsonProperty(value="TierBand")
    private List<OBReadProduct2DataOtherProductTypeCreditInterestTierBand> tierBand = new ArrayList<OBReadProduct2DataOtherProductTypeCreditInterestTierBand>();

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet tierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The methodology of how credit interest is paid/applied. It can be:- 1. Banded Interest rates are banded. i.e. Increasing rate on whole balance as balance increases. 2. Tiered Interest rates are tiered. i.e. increasing rate for each tier as balance increases, but interest paid on tier fixed for that tier and not on whole balance. 3. Whole The same interest rate is applied irrespective of the product holder's account balance")
    public TierBandMethodEnum getTierBandMethod() {
        return this.tierBandMethod;
    }

    public void setTierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet calculationMethod(OBInterestCalculationMethod1Code calculationMethod) {
        this.calculationMethod = calculationMethod;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBInterestCalculationMethod1Code getCalculationMethod() {
        return this.calculationMethod;
    }

    public void setCalculationMethod(OBInterestCalculationMethod1Code calculationMethod) {
        this.calculationMethod = calculationMethod;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet destination(DestinationEnum destination) {
        this.destination = destination;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Describes whether accrued interest is payable only to the BCA or to another bank account")
    public DestinationEnum getDestination() {
        return this.destination;
    }

    public void setDestination(DestinationEnum destination) {
        this.destination = destination;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet otherCalculationMethod(OBOtherCodeType10 otherCalculationMethod) {
        this.otherCalculationMethod = otherCalculationMethod;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBOtherCodeType10 getOtherCalculationMethod() {
        return this.otherCalculationMethod;
    }

    public void setOtherCalculationMethod(OBOtherCodeType10 otherCalculationMethod) {
        this.otherCalculationMethod = otherCalculationMethod;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet otherDestination(OBOtherCodeType10 otherDestination) {
        this.otherDestination = otherDestination;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBOtherCodeType10 getOtherDestination() {
        return this.otherDestination;
    }

    public void setOtherDestination(OBOtherCodeType10 otherDestination) {
        this.otherDestination = otherDestination;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet tierBand(List<OBReadProduct2DataOtherProductTypeCreditInterestTierBand> tierBand) {
        this.tierBand = tierBand;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet addTierBandItem(OBReadProduct2DataOtherProductTypeCreditInterestTierBand tierBandItem) {
        this.tierBand.add(tierBandItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="")
    public List<OBReadProduct2DataOtherProductTypeCreditInterestTierBand> getTierBand() {
        return this.tierBand;
    }

    public void setTierBand(List<OBReadProduct2DataOtherProductTypeCreditInterestTierBand> tierBand) {
        this.tierBand = tierBand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet obReadProduct2DataOtherProductTypeCreditInterestTierBandSet = (OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet)o;
        return Objects.equals((Object)this.tierBandMethod, (Object)obReadProduct2DataOtherProductTypeCreditInterestTierBandSet.tierBandMethod) && Objects.equals((Object)this.calculationMethod, (Object)obReadProduct2DataOtherProductTypeCreditInterestTierBandSet.calculationMethod) && Objects.equals((Object)this.destination, (Object)obReadProduct2DataOtherProductTypeCreditInterestTierBandSet.destination) && Objects.equals(this.notes, obReadProduct2DataOtherProductTypeCreditInterestTierBandSet.notes) && Objects.equals(this.otherCalculationMethod, obReadProduct2DataOtherProductTypeCreditInterestTierBandSet.otherCalculationMethod) && Objects.equals(this.otherDestination, obReadProduct2DataOtherProductTypeCreditInterestTierBandSet.otherDestination) && Objects.equals(this.tierBand, obReadProduct2DataOtherProductTypeCreditInterestTierBandSet.tierBand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierBandMethod, this.calculationMethod, this.destination, this.notes, this.otherCalculationMethod, this.otherDestination, this.tierBand});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadProduct2DataOtherProductTypeCreditInterestTierBandSet {\n");
        sb.append("    tierBandMethod: ").append(this.toIndentedString((Object)this.tierBandMethod)).append("\n");
        sb.append("    calculationMethod: ").append(this.toIndentedString((Object)this.calculationMethod)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString((Object)this.destination)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherCalculationMethod: ").append(this.toIndentedString(this.otherCalculationMethod)).append("\n");
        sb.append("    otherDestination: ").append(this.toIndentedString(this.otherDestination)).append("\n");
        sb.append("    tierBand: ").append(this.toIndentedString(this.tierBand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DestinationEnum {
        INOT("INOT"),
        INPA("INPA"),
        INSC("INSC");

        private String value;

        private DestinationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DestinationEnum fromValue(String text) {
            for (DestinationEnum b : DestinationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TierBandMethodEnum {
        INBA("INBA"),
        INTI("INTI"),
        INWH("INWH");

        private String value;

        private TierBandMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TierBandMethodEnum fromValue(String text) {
            for (TierBandMethodEnum b : TierBandMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

