/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBMinMaxType1Code;
import uk.org.openbanking.datamodel.account.OBPeriod1Code;
import uk.org.openbanking.datamodel.account.OBReadProduct2DataOtherProductTypeOverdraftOtherFeeType;

@ApiModel(description="Details about any caps (maximum charges) that apply to a particular fee/charge. Capping can either be based on an amount (in gbp), an amount (in items) or a rate.")
public class OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap {
    @JsonProperty(value="FeeType")
    private List<FeeTypeEnum> feeType = new ArrayList<FeeTypeEnum>();
    @JsonProperty(value="MinMaxType")
    private OBMinMaxType1Code minMaxType = null;
    @JsonProperty(value="FeeCapOccurrence")
    private Integer feeCapOccurrence = null;
    @JsonProperty(value="FeeCapAmount")
    private String feeCapAmount = null;
    @JsonProperty(value="CappingPeriod")
    private OBPeriod1Code cappingPeriod = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherFeeType")
    private List<OBReadProduct2DataOtherProductTypeOverdraftOtherFeeType> otherFeeType = null;

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap feeType(List<FeeTypeEnum> feeType) {
        this.feeType = feeType;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap addFeeTypeItem(FeeTypeEnum feeTypeItem) {
        this.feeType.add(feeTypeItem);
        return this;
    }

    @NotNull
    @Size(min=1)
    @ApiModelProperty(required=true, value="")
    public List<FeeTypeEnum> getFeeType() {
        return this.feeType;
    }

    public void setFeeType(List<FeeTypeEnum> feeType) {
        this.feeType = feeType;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap minMaxType(OBMinMaxType1Code minMaxType) {
        this.minMaxType = minMaxType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBMinMaxType1Code getMinMaxType() {
        return this.minMaxType;
    }

    public void setMinMaxType(OBMinMaxType1Code minMaxType) {
        this.minMaxType = minMaxType;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap feeCapOccurrence(Integer feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getFeeCapOccurrence() {
        return this.feeCapOccurrence;
    }

    public void setFeeCapOccurrence(Integer feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap feeCapAmount(String feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="")
    public String getFeeCapAmount() {
        return this.feeCapAmount;
    }

    public void setFeeCapAmount(String feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap cappingPeriod(OBPeriod1Code cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBPeriod1Code getCappingPeriod() {
        return this.cappingPeriod;
    }

    public void setCappingPeriod(OBPeriod1Code cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap otherFeeType(List<OBReadProduct2DataOtherProductTypeOverdraftOtherFeeType> otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    public OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap addOtherFeeTypeItem(OBReadProduct2DataOtherProductTypeOverdraftOtherFeeType otherFeeTypeItem) {
        if (this.otherFeeType == null) {
            this.otherFeeType = new ArrayList<OBReadProduct2DataOtherProductTypeOverdraftOtherFeeType>();
        }
        this.otherFeeType.add(otherFeeTypeItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBReadProduct2DataOtherProductTypeOverdraftOtherFeeType> getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(List<OBReadProduct2DataOtherProductTypeOverdraftOtherFeeType> otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap obReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap = (OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap)o;
        return Objects.equals(this.feeType, obReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap.feeType) && Objects.equals((Object)this.minMaxType, (Object)obReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap.minMaxType) && Objects.equals(this.feeCapOccurrence, obReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap.feeCapOccurrence) && Objects.equals(this.feeCapAmount, obReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap.feeCapAmount) && Objects.equals((Object)this.cappingPeriod, (Object)obReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap.cappingPeriod) && Objects.equals(this.notes, obReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap.notes) && Objects.equals(this.otherFeeType, obReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap.otherFeeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeType, this.minMaxType, this.feeCapOccurrence, this.feeCapAmount, this.cappingPeriod, this.notes, this.otherFeeType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBReadProduct2DataOtherProductTypeOverdraftOverdraftFeeChargeCap {\n");
        sb.append("    feeType: ").append(this.toIndentedString(this.feeType)).append("\n");
        sb.append("    minMaxType: ").append(this.toIndentedString((Object)this.minMaxType)).append("\n");
        sb.append("    feeCapOccurrence: ").append(this.toIndentedString(this.feeCapOccurrence)).append("\n");
        sb.append("    feeCapAmount: ").append(this.toIndentedString(this.feeCapAmount)).append("\n");
        sb.append("    cappingPeriod: ").append(this.toIndentedString((Object)this.cappingPeriod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FeeTypeEnum {
        FBAO("FBAO"),
        FBAR("FBAR"),
        FBEB("FBEB"),
        FBIT("FBIT"),
        FBOR("FBOR"),
        FBOS("FBOS"),
        FBSC("FBSC"),
        FBTO("FBTO"),
        FBUB("FBUB"),
        FBUT("FBUT"),
        FTOT("FTOT"),
        FTUT("FTUT");

        private String value;

        private FeeTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeTypeEnum fromValue(String text) {
            for (FeeTypeEnum b : FeeTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

