/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import uk.org.openbanking.datamodel.account.OBReadData1;
import uk.org.openbanking.datamodel.account.OBRisk2;

@ApiModel(description="Allows setup of an account access request")
public class OBReadRequest1 {
    @JsonProperty(value="Data")
    private OBReadData1 data = null;
    @JsonProperty(value="Risk")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private OBRisk2 risk = null;

    public OBReadRequest1 data(OBReadData1 data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @NotNull
    public OBReadData1 getData() {
        return this.data;
    }

    public void setData(OBReadData1 data) {
        this.data = data;
    }

    public OBReadRequest1 risk(OBRisk2 risk) {
        this.risk = risk;
        return this;
    }

    @ApiModelProperty(required=true, value="The Risk payload is sent by the initiating party to the ASPSP. It is used to specify additional details for risk scoring for Account Info.")
    public OBRisk2 getRisk() {
        return this.risk;
    }

    public void setRisk(OBRisk2 risk) {
        this.risk = risk;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBReadRequest1 accountRequestPOSTRequest = (OBReadRequest1)o;
        return Objects.equals(this.data, accountRequestPOSTRequest.data) && Objects.equals(this.risk, accountRequestPOSTRequest.risk);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.risk);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountRequestPOSTRequest {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    risk: ").append(this.toIndentedString(this.risk)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

