/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification4;
import uk.org.openbanking.datamodel.account.OBCashAccount3;
import uk.org.openbanking.datamodel.account.OBExternalScheduleType1Code;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@Validated
public class OBScheduledPayment1 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="ScheduledPaymentId")
    private String scheduledPaymentId = null;
    @JsonProperty(value="ScheduledPaymentDateTime")
    private DateTime scheduledPaymentDateTime = null;
    @JsonProperty(value="ScheduledType")
    private OBExternalScheduleType1Code scheduledType = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="InstructedAmount")
    private OBActiveOrHistoricCurrencyAndAmount instructedAmount = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification4 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount3 creditorAccount = null;

    public OBScheduledPayment1 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBScheduledPayment1 scheduledPaymentId(String scheduledPaymentId) {
        this.scheduledPaymentId = scheduledPaymentId;
        return this;
    }

    @ApiModelProperty(value="A unique and immutable identifier used to identify the scheduled payment resource. This identifier has no meaning to the account owner.")
    @Size(min=1, max=40)
    public String getScheduledPaymentId() {
        return this.scheduledPaymentId;
    }

    public void setScheduledPaymentId(String scheduledPaymentId) {
        this.scheduledPaymentId = scheduledPaymentId;
    }

    public OBScheduledPayment1 scheduledPaymentDateTime(DateTime scheduledPaymentDateTime) {
        this.scheduledPaymentDateTime = scheduledPaymentDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The date on which the scheduled payment will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getScheduledPaymentDateTime() {
        return this.scheduledPaymentDateTime;
    }

    public void setScheduledPaymentDateTime(DateTime scheduledPaymentDateTime) {
        this.scheduledPaymentDateTime = scheduledPaymentDateTime;
    }

    public OBScheduledPayment1 scheduledType(OBExternalScheduleType1Code scheduledType) {
        this.scheduledType = scheduledType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalScheduleType1Code getScheduledType() {
        return this.scheduledType;
    }

    public void setScheduledType(OBExternalScheduleType1Code scheduledType) {
        this.scheduledType = scheduledType;
    }

    public OBScheduledPayment1 reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    @Size(min=1, max=35)
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBScheduledPayment1 instructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBScheduledPayment1 creditorAgent(OBBranchAndFinancialInstitutionIdentification4 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification4 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification4 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBScheduledPayment1 creditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount3 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBScheduledPayment1 obScheduledPayment1 = (OBScheduledPayment1)o;
        return Objects.equals(this.accountId, obScheduledPayment1.accountId) && Objects.equals(this.scheduledPaymentId, obScheduledPayment1.scheduledPaymentId) && Objects.equals(this.scheduledPaymentDateTime, obScheduledPayment1.scheduledPaymentDateTime) && Objects.equals((Object)this.scheduledType, (Object)obScheduledPayment1.scheduledType) && Objects.equals(this.reference, obScheduledPayment1.reference) && Objects.equals(this.instructedAmount, obScheduledPayment1.instructedAmount) && Objects.equals(this.creditorAgent, obScheduledPayment1.creditorAgent) && Objects.equals(this.creditorAccount, obScheduledPayment1.creditorAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.scheduledPaymentId, this.scheduledPaymentDateTime, this.scheduledType, this.reference, this.instructedAmount, this.creditorAgent, this.creditorAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBScheduledPayment1 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    scheduledPaymentId: ").append(this.toIndentedString(this.scheduledPaymentId)).append("\n");
        sb.append("    scheduledPaymentDateTime: ").append(this.toIndentedString(this.scheduledPaymentDateTime)).append("\n");
        sb.append("    scheduledType: ").append(this.toIndentedString((Object)this.scheduledType)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

