/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.account.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification5;
import uk.org.openbanking.datamodel.account.OBCashAccount5;
import uk.org.openbanking.datamodel.account.OBExternalScheduleType1Code;

public class OBScheduledPayment2 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="ScheduledPaymentId")
    private String scheduledPaymentId = null;
    @JsonProperty(value="ScheduledPaymentDateTime")
    private DateTime scheduledPaymentDateTime = null;
    @JsonProperty(value="ScheduledType")
    private OBExternalScheduleType1Code scheduledType = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="InstructedAmount")
    private OBActiveOrHistoricCurrencyAndAmount instructedAmount = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification5 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount5 creditorAccount = null;

    public OBScheduledPayment2 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBScheduledPayment2 scheduledPaymentId(String scheduledPaymentId) {
        this.scheduledPaymentId = scheduledPaymentId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="A unique and immutable identifier used to identify the scheduled payment resource. This identifier has no meaning to the account owner.")
    public String getScheduledPaymentId() {
        return this.scheduledPaymentId;
    }

    public void setScheduledPaymentId(String scheduledPaymentId) {
        this.scheduledPaymentId = scheduledPaymentId;
    }

    public OBScheduledPayment2 scheduledPaymentDateTime(DateTime scheduledPaymentDateTime) {
        this.scheduledPaymentDateTime = scheduledPaymentDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="The date on which the scheduled payment will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getScheduledPaymentDateTime() {
        return this.scheduledPaymentDateTime;
    }

    public void setScheduledPaymentDateTime(DateTime scheduledPaymentDateTime) {
        this.scheduledPaymentDateTime = scheduledPaymentDateTime;
    }

    public OBScheduledPayment2 scheduledType(OBExternalScheduleType1Code scheduledType) {
        this.scheduledType = scheduledType;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBExternalScheduleType1Code getScheduledType() {
        return this.scheduledType;
    }

    public void setScheduledType(OBExternalScheduleType1Code scheduledType) {
        this.scheduledType = scheduledType;
    }

    public OBScheduledPayment2 reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBScheduledPayment2 instructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBActiveOrHistoricCurrencyAndAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBScheduledPayment2 creditorAgent(OBBranchAndFinancialInstitutionIdentification5 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBBranchAndFinancialInstitutionIdentification5 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification5 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBScheduledPayment2 creditorAccount(OBCashAccount5 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBCashAccount5 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount5 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBScheduledPayment2 obScheduledPayment2 = (OBScheduledPayment2)o;
        return Objects.equals(this.accountId, obScheduledPayment2.accountId) && Objects.equals(this.scheduledPaymentId, obScheduledPayment2.scheduledPaymentId) && Objects.equals(this.scheduledPaymentDateTime, obScheduledPayment2.scheduledPaymentDateTime) && Objects.equals((Object)this.scheduledType, (Object)obScheduledPayment2.scheduledType) && Objects.equals(this.reference, obScheduledPayment2.reference) && Objects.equals(this.instructedAmount, obScheduledPayment2.instructedAmount) && Objects.equals(this.creditorAgent, obScheduledPayment2.creditorAgent) && Objects.equals(this.creditorAccount, obScheduledPayment2.creditorAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.scheduledPaymentId, this.scheduledPaymentDateTime, this.scheduledType, this.reference, this.instructedAmount, this.creditorAgent, this.creditorAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBScheduledPayment2 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    scheduledPaymentId: ").append(this.toIndentedString(this.scheduledPaymentId)).append("\n");
        sb.append("    scheduledPaymentDateTime: ").append(this.toIndentedString(this.scheduledPaymentDateTime)).append("\n");
        sb.append("    scheduledType: ").append(this.toIndentedString((Object)this.scheduledType)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

