/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification2;
import uk.org.openbanking.datamodel.account.OBCashAccount1;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.jackson.DateTimeDeserializer;
import uk.org.openbanking.jackson.DateTimeSerializer;

@ApiModel(description="Standing Order")
public class OBStandingOrder1 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="StandingOrderId")
    private String standingOrderId = null;
    @JsonProperty(value="Frequency")
    private String frequency = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="FirstPaymentDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime firstPaymentDateTime = null;
    @JsonProperty(value="FirstPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount firstPaymentAmount = null;
    @JsonProperty(value="NextPaymentDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime nextPaymentDateTime = null;
    @JsonProperty(value="NextPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount nextPaymentAmount = null;
    @JsonProperty(value="FinalPaymentDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime finalPaymentDateTime = null;
    @JsonProperty(value="FinalPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount finalPaymentAmount = null;
    @JsonProperty(value="Servicer")
    private OBBranchAndFinancialInstitutionIdentification2 servicer = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount1 creditorAccount = null;

    public OBStandingOrder1 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The date on which the first payment for a Standing Order schedule will be made.")
    @NotNull
    @Size(min=1, max=40)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBStandingOrder1 standingOrderId(String standingOrderId) {
        this.standingOrderId = standingOrderId;
        return this;
    }

    @ApiModelProperty(value="A unique and immutable identifier used to identify the standing order resource. This identifier has no meaning to the account owner.")
    @Size(min=1, max=40)
    public String getStandingOrderId() {
        return this.standingOrderId;
    }

    public void setStandingOrderId(String standingOrderId) {
        this.standingOrderId = standingOrderId;
    }

    public OBStandingOrder1 frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(required=true, value="EvryDay - Every day EvryWorkgDay - Every working day IntrvlWkDay - An interval specified in weeks (01 to 09), and the day within the week (01 to 07) WkInMnthDay - A monthly interval, specifying the week of the month (01 to 05) and day within the week (01 to 07) IntrvlMnthDay - An interval specified in months (between 01 to 06, 12, 24), specifying the day within the month (-5 to -1, 1 to 31) QtrDay - Quarterly (either ENGLISH, SCOTTISH, or RECEIVED) Patterns:  EvryDay (ScheduleCode) EvryWorkgDay (ScheduleCode) IntrvlWkDay:IntervalInWeeks:DayInWeek (ScheduleCode + IntervalInWeeks + DayInWeek) WkInMnthDay:WeekInMonth:DayInWeek (ScheduleCode + WeekInMonth + DayInWeek) IntrvlMnthDay:IntervalInMonths:DayInMonth (ScheduleCode + IntervalInMonths + DayInMonth) QtrDay: + either (ENGLISH, SCOTTISH or RECEIVED) ScheduleCode + QuarterDay  The regular expression for this element combines five smaller versions for each permitted pattern. To aid legibility - the components are presented individually here: EvryDay EvryWorkgDay IntrvlWkDay:0[1-9]:0[1-7] WkInMnthDay:0[1-5]:0[1-7] IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]) QtrDay:(ENGLISH|SCOTTISH|RECEIVED) ")
    @NotNull
    @Pattern(regexp="^(EvryDay)$|^(EvryWorkgDay)$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public OBStandingOrder1 reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    @Size(min=1, max=35)
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBStandingOrder1 firstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="The date on which the first payment for a Standing Order schedule will be made.  All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getFirstPaymentDateTime() {
        return this.firstPaymentDateTime;
    }

    public void setFirstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
    }

    public OBStandingOrder1 firstPaymentAmount(OBActiveOrHistoricCurrencyAndAmount firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getFirstPaymentAmount() {
        return this.firstPaymentAmount;
    }

    public void setFirstPaymentAmount(OBActiveOrHistoricCurrencyAndAmount firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
    }

    public OBStandingOrder1 nextPaymentDateTime(DateTime nextPaymentDateTime) {
        this.nextPaymentDateTime = nextPaymentDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The date on which the next payment for a Standing Order schedule will be made.  All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getNextPaymentDateTime() {
        return this.nextPaymentDateTime;
    }

    public void setNextPaymentDateTime(DateTime nextPaymentDateTime) {
        this.nextPaymentDateTime = nextPaymentDateTime;
    }

    public OBStandingOrder1 nextPaymentAmount(OBActiveOrHistoricCurrencyAndAmount nextPaymentAmount) {
        this.nextPaymentAmount = nextPaymentAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getNextPaymentAmount() {
        return this.nextPaymentAmount;
    }

    public void setNextPaymentAmount(OBActiveOrHistoricCurrencyAndAmount nextPaymentAmount) {
        this.nextPaymentAmount = nextPaymentAmount;
    }

    public OBStandingOrder1 finalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="The date on which the final payment for a Standing Order schedule will be made.  All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getFinalPaymentDateTime() {
        return this.finalPaymentDateTime;
    }

    public void setFinalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
    }

    public OBStandingOrder1 finalPaymentAmount(OBActiveOrHistoricCurrencyAndAmount finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getFinalPaymentAmount() {
        return this.finalPaymentAmount;
    }

    public void setFinalPaymentAmount(OBActiveOrHistoricCurrencyAndAmount finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
    }

    public OBStandingOrder1 servicer(OBBranchAndFinancialInstitutionIdentification2 servicer) {
        this.servicer = servicer;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification2 getServicer() {
        return this.servicer;
    }

    public void setServicer(OBBranchAndFinancialInstitutionIdentification2 servicer) {
        this.servicer = servicer;
    }

    public OBStandingOrder1 creditorAccount(OBCashAccount1 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount1 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount1 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStandingOrder1 standingOrder = (OBStandingOrder1)o;
        return Objects.equals(this.accountId, standingOrder.accountId) && Objects.equals(this.standingOrderId, standingOrder.standingOrderId) && Objects.equals(this.frequency, standingOrder.frequency) && Objects.equals(this.reference, standingOrder.reference) && Objects.equals(this.firstPaymentDateTime, standingOrder.firstPaymentDateTime) && Objects.equals(this.firstPaymentAmount, standingOrder.firstPaymentAmount) && Objects.equals(this.nextPaymentDateTime, standingOrder.nextPaymentDateTime) && Objects.equals(this.nextPaymentAmount, standingOrder.nextPaymentAmount) && Objects.equals(this.finalPaymentDateTime, standingOrder.finalPaymentDateTime) && Objects.equals(this.finalPaymentAmount, standingOrder.finalPaymentAmount) && Objects.equals(this.servicer, standingOrder.servicer) && Objects.equals(this.creditorAccount, standingOrder.creditorAccount);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.standingOrderId, this.frequency, this.reference, this.firstPaymentDateTime, this.firstPaymentAmount, this.nextPaymentDateTime, this.nextPaymentAmount, this.finalPaymentDateTime, this.finalPaymentAmount, this.servicer, this.creditorAccount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandingOrder {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    standingOrderId: ").append(this.toIndentedString(this.standingOrderId)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    firstPaymentDateTime: ").append(this.toIndentedString(this.firstPaymentDateTime)).append("\n");
        sb.append("    firstPaymentAmount: ").append(this.toIndentedString(this.firstPaymentAmount)).append("\n");
        sb.append("    nextPaymentDateTime: ").append(this.toIndentedString(this.nextPaymentDateTime)).append("\n");
        sb.append("    nextPaymentAmount: ").append(this.toIndentedString(this.nextPaymentAmount)).append("\n");
        sb.append("    finalPaymentDateTime: ").append(this.toIndentedString(this.finalPaymentDateTime)).append("\n");
        sb.append("    finalPaymentAmount: ").append(this.toIndentedString(this.finalPaymentAmount)).append("\n");
        sb.append("    servicer: ").append(this.toIndentedString(this.servicer)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

