/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification2;
import uk.org.openbanking.datamodel.account.OBCashAccount1;
import uk.org.openbanking.datamodel.account.OBExternalStandingOrderStatus1Code;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.jackson.DateTimeDeserializer;
import uk.org.openbanking.jackson.DateTimeSerializer;

@ApiModel(description="Account to or from which a cash entry is made.")
@Validated
public class OBStandingOrder2 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="StandingOrderId")
    private String standingOrderId = null;
    @JsonProperty(value="Frequency")
    private String frequency = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="FirstPaymentDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime firstPaymentDateTime = null;
    @JsonProperty(value="FirstPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount firstPaymentAmount = null;
    @JsonProperty(value="NextPaymentDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime nextPaymentDateTime = null;
    @JsonProperty(value="NextPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount nextPaymentAmount = null;
    @JsonProperty(value="FinalPaymentDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime finalPaymentDateTime = null;
    @JsonProperty(value="FinalPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount finalPaymentAmount = null;
    @JsonProperty(value="StandingOrderStatusCode")
    private OBExternalStandingOrderStatus1Code standingOrderStatusCode = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification2 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount1 creditorAccount = null;

    public OBStandingOrder2 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique and immutable identifier used to identify the account resource. This identifier has no meaning to the account owner.")
    @NotNull
    @Size(min=1, max=40)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBStandingOrder2 standingOrderId(String standingOrderId) {
        this.standingOrderId = standingOrderId;
        return this;
    }

    @ApiModelProperty(value="A unique and immutable identifier used to identify the standing order resource. This identifier has no meaning to the account owner.")
    @Size(min=1, max=40)
    public String getStandingOrderId() {
        return this.standingOrderId;
    }

    public void setStandingOrderId(String standingOrderId) {
        this.standingOrderId = standingOrderId;
    }

    public OBStandingOrder2 frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(required=true, value="Individual Definitions: EvryDay - Every day EvryWorkgDay - Every working day IntrvlWkDay - An interval specified in weeks (01 to 09), and the day within the week (01 to 07) WkInMnthDay - A monthly interval, specifying the week of the month (01 to 05) and day within the week (01 to 07) IntrvlMnthDay - An interval specified in months (between 01 to 06, 12, 24), specifying the day within the month (-5 to -1, 1 to 31) QtrDay - Quarterly (either ENGLISH, SCOTTISH, or RECEIVED) Individual Patterns: EvryDay (ScheduleCode) EvryWorkgDay (ScheduleCode) IntrvlWkDay:IntervalInWeeks:DayInWeek (ScheduleCode + IntervalInWeeks + DayInWeek) WkInMnthDay:WeekInMonth:DayInWeek (ScheduleCode + WeekInMonth + DayInWeek) IntrvlMnthDay:IntervalInMonths:DayInMonth (ScheduleCode + IntervalInMonths + DayInMonth) QtrDay: + either (ENGLISH, SCOTTISH or RECEIVED) ScheduleCode + QuarterDay The regular expression for this element combines five smaller versions for each permitted pattern. To aid legibility - the components are presented individually here: EvryDay EvryWorkgDay IntrvlWkDay:0[1-9]:0[1-7] WkInMnthDay:0[1-5]:0[1-7] IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]) QtrDay:(ENGLISH|SCOTTISH|RECEIVED) Full Regular Expression: ^(EvryDay)$|^(EvryWorkgDay)$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    @NotNull
    @Pattern(regexp="^(EvryDay)$|^(EvryWorkgDay)$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    @Size(min=1, max=35)
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public OBStandingOrder2 reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Unique reference, as assigned by the creditor, to unambiguously refer to the payment transaction. Usage: If available, the initiating party should provide this reference in the structured remittance information, to enable reconciliation by the creditor upon receipt of the amount of money. If the business context requires the use of a creditor reference or a payment remit identification, and only one identifier can be passed through the end-to-end chain, the creditor's reference or payment remittance identification should be quoted in the end-to-end transaction identification.")
    @Size(min=1, max=35)
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBStandingOrder2 firstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="The date on which the first payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getFirstPaymentDateTime() {
        return this.firstPaymentDateTime;
    }

    public void setFirstPaymentDateTime(DateTime firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
    }

    public OBStandingOrder2 firstPaymentAmount(OBActiveOrHistoricCurrencyAndAmount firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getFirstPaymentAmount() {
        return this.firstPaymentAmount;
    }

    public void setFirstPaymentAmount(OBActiveOrHistoricCurrencyAndAmount firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
    }

    public OBStandingOrder2 nextPaymentDateTime(DateTime nextPaymentDateTime) {
        this.nextPaymentDateTime = nextPaymentDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The date on which the next payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getNextPaymentDateTime() {
        return this.nextPaymentDateTime;
    }

    public void setNextPaymentDateTime(DateTime nextPaymentDateTime) {
        this.nextPaymentDateTime = nextPaymentDateTime;
    }

    public OBStandingOrder2 nextPaymentAmount(OBActiveOrHistoricCurrencyAndAmount nextPaymentAmount) {
        this.nextPaymentAmount = nextPaymentAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getNextPaymentAmount() {
        return this.nextPaymentAmount;
    }

    public void setNextPaymentAmount(OBActiveOrHistoricCurrencyAndAmount nextPaymentAmount) {
        this.nextPaymentAmount = nextPaymentAmount;
    }

    public OBStandingOrder2 finalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="The date on which the final payment for a Standing Order schedule will be made. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getFinalPaymentDateTime() {
        return this.finalPaymentDateTime;
    }

    public void setFinalPaymentDateTime(DateTime finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
    }

    public OBStandingOrder2 finalPaymentAmount(OBActiveOrHistoricCurrencyAndAmount finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getFinalPaymentAmount() {
        return this.finalPaymentAmount;
    }

    public void setFinalPaymentAmount(OBActiveOrHistoricCurrencyAndAmount finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
    }

    public OBStandingOrder2 standingOrderStatusCode(OBExternalStandingOrderStatus1Code standingOrderStatusCode) {
        this.standingOrderStatusCode = standingOrderStatusCode;
        return this;
    }

    @ApiModelProperty(value="Specifies the status of the standing order in code form.")
    public OBExternalStandingOrderStatus1Code getStandingOrderStatusCode() {
        return this.standingOrderStatusCode;
    }

    public void setStandingOrderStatusCode(OBExternalStandingOrderStatus1Code standingOrderStatusCode) {
        this.standingOrderStatusCode = standingOrderStatusCode;
    }

    public OBStandingOrder2 creditorAgent(OBBranchAndFinancialInstitutionIdentification2 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification2 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification2 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBStandingOrder2 creditorAccount(OBCashAccount1 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount1 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount1 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStandingOrder2 obStandingOrder2 = (OBStandingOrder2)o;
        return Objects.equals(this.accountId, obStandingOrder2.accountId) && Objects.equals(this.standingOrderId, obStandingOrder2.standingOrderId) && Objects.equals(this.frequency, obStandingOrder2.frequency) && Objects.equals(this.reference, obStandingOrder2.reference) && Objects.equals(this.firstPaymentDateTime, obStandingOrder2.firstPaymentDateTime) && Objects.equals(this.firstPaymentAmount, obStandingOrder2.firstPaymentAmount) && Objects.equals(this.nextPaymentDateTime, obStandingOrder2.nextPaymentDateTime) && Objects.equals(this.nextPaymentAmount, obStandingOrder2.nextPaymentAmount) && Objects.equals(this.finalPaymentDateTime, obStandingOrder2.finalPaymentDateTime) && Objects.equals(this.finalPaymentAmount, obStandingOrder2.finalPaymentAmount) && Objects.equals((Object)this.standingOrderStatusCode, (Object)obStandingOrder2.standingOrderStatusCode) && Objects.equals(this.creditorAgent, obStandingOrder2.creditorAgent) && Objects.equals(this.creditorAccount, obStandingOrder2.creditorAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.standingOrderId, this.frequency, this.reference, this.firstPaymentDateTime, this.firstPaymentAmount, this.nextPaymentDateTime, this.nextPaymentAmount, this.finalPaymentDateTime, this.finalPaymentAmount, this.standingOrderStatusCode, this.creditorAgent, this.creditorAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStandingOrder2 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    standingOrderId: ").append(this.toIndentedString(this.standingOrderId)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    firstPaymentDateTime: ").append(this.toIndentedString(this.firstPaymentDateTime)).append("\n");
        sb.append("    firstPaymentAmount: ").append(this.toIndentedString(this.firstPaymentAmount)).append("\n");
        sb.append("    nextPaymentDateTime: ").append(this.toIndentedString(this.nextPaymentDateTime)).append("\n");
        sb.append("    nextPaymentAmount: ").append(this.toIndentedString(this.nextPaymentAmount)).append("\n");
        sb.append("    finalPaymentDateTime: ").append(this.toIndentedString(this.finalPaymentDateTime)).append("\n");
        sb.append("    finalPaymentAmount: ").append(this.toIndentedString(this.finalPaymentAmount)).append("\n");
        sb.append("    standingOrderStatusCode: ").append(this.toIndentedString((Object)this.standingOrderStatusCode)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

