/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBActiveOrHistoricCurrencyAndAmount0;
import uk.org.openbanking.datamodel.account.OBActiveOrHistoricCurrencyAndAmount1;
import uk.org.openbanking.datamodel.account.OBActiveOrHistoricCurrencyAndAmount2;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification51;
import uk.org.openbanking.datamodel.account.OBCashAccount50;
import uk.org.openbanking.datamodel.account.OBExternalStandingOrderStatus1Code;
import uk.org.openbanking.datamodel.account.OBSupplementaryData1;

public class OBStandingOrder4Detail {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="StandingOrderId")
    private String standingOrderId = null;
    @JsonProperty(value="Frequency")
    private String frequency = null;
    @JsonProperty(value="Reference")
    private String reference = null;
    @JsonProperty(value="FirstPaymentDateTime")
    private String firstPaymentDateTime = null;
    @JsonProperty(value="NextPaymentDateTime")
    private String nextPaymentDateTime = null;
    @JsonProperty(value="FinalPaymentDateTime")
    private String finalPaymentDateTime = null;
    @JsonProperty(value="StandingOrderStatusCode")
    private OBExternalStandingOrderStatus1Code standingOrderStatusCode = null;
    @JsonProperty(value="FirstPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount0 firstPaymentAmount = null;
    @JsonProperty(value="NextPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount1 nextPaymentAmount = null;
    @JsonProperty(value="FinalPaymentAmount")
    private OBActiveOrHistoricCurrencyAndAmount2 finalPaymentAmount = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification51 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount50 creditorAccount = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;

    public OBStandingOrder4Detail accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBStandingOrder4Detail standingOrderId(String standingOrderId) {
        this.standingOrderId = standingOrderId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="")
    public String getStandingOrderId() {
        return this.standingOrderId;
    }

    public void setStandingOrderId(String standingOrderId) {
        this.standingOrderId = standingOrderId;
    }

    public OBStandingOrder4Detail frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @NotNull
    @Pattern(regexp="^(EvryDay)$|^(EvryWorkgDay)$|^(IntrvlWkDay:0[1-9]:0[1-7])$|^(WkInMnthDay:0[1-5]:0[1-7])$|^(IntrvlMnthDay:(0[1-6]|12|24):(-0[1-5]|0[1-9]|[12][0-9]|3[01]))$|^(QtrDay:(ENGLISH|SCOTTISH|RECEIVED))$")
    @ApiModelProperty(required=true, value="")
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public OBStandingOrder4Detail reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public OBStandingOrder4Detail firstPaymentDateTime(String firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="")
    public String getFirstPaymentDateTime() {
        return this.firstPaymentDateTime;
    }

    public void setFirstPaymentDateTime(String firstPaymentDateTime) {
        this.firstPaymentDateTime = firstPaymentDateTime;
    }

    public OBStandingOrder4Detail nextPaymentDateTime(String nextPaymentDateTime) {
        this.nextPaymentDateTime = nextPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="")
    public String getNextPaymentDateTime() {
        return this.nextPaymentDateTime;
    }

    public void setNextPaymentDateTime(String nextPaymentDateTime) {
        this.nextPaymentDateTime = nextPaymentDateTime;
    }

    public OBStandingOrder4Detail finalPaymentDateTime(String finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
        return this;
    }

    @ApiModelProperty(value="")
    public String getFinalPaymentDateTime() {
        return this.finalPaymentDateTime;
    }

    public void setFinalPaymentDateTime(String finalPaymentDateTime) {
        this.finalPaymentDateTime = finalPaymentDateTime;
    }

    public OBStandingOrder4Detail standingOrderStatusCode(OBExternalStandingOrderStatus1Code standingOrderStatusCode) {
        this.standingOrderStatusCode = standingOrderStatusCode;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBExternalStandingOrderStatus1Code getStandingOrderStatusCode() {
        return this.standingOrderStatusCode;
    }

    public void setStandingOrderStatusCode(OBExternalStandingOrderStatus1Code standingOrderStatusCode) {
        this.standingOrderStatusCode = standingOrderStatusCode;
    }

    public OBStandingOrder4Detail firstPaymentAmount(OBActiveOrHistoricCurrencyAndAmount0 firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBActiveOrHistoricCurrencyAndAmount0 getFirstPaymentAmount() {
        return this.firstPaymentAmount;
    }

    public void setFirstPaymentAmount(OBActiveOrHistoricCurrencyAndAmount0 firstPaymentAmount) {
        this.firstPaymentAmount = firstPaymentAmount;
    }

    public OBStandingOrder4Detail nextPaymentAmount(OBActiveOrHistoricCurrencyAndAmount1 nextPaymentAmount) {
        this.nextPaymentAmount = nextPaymentAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBActiveOrHistoricCurrencyAndAmount1 getNextPaymentAmount() {
        return this.nextPaymentAmount;
    }

    public void setNextPaymentAmount(OBActiveOrHistoricCurrencyAndAmount1 nextPaymentAmount) {
        this.nextPaymentAmount = nextPaymentAmount;
    }

    public OBStandingOrder4Detail finalPaymentAmount(OBActiveOrHistoricCurrencyAndAmount2 finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBActiveOrHistoricCurrencyAndAmount2 getFinalPaymentAmount() {
        return this.finalPaymentAmount;
    }

    public void setFinalPaymentAmount(OBActiveOrHistoricCurrencyAndAmount2 finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
    }

    public OBStandingOrder4Detail creditorAgent(OBBranchAndFinancialInstitutionIdentification51 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBBranchAndFinancialInstitutionIdentification51 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification51 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBStandingOrder4Detail creditorAccount(OBCashAccount50 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBCashAccount50 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount50 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBStandingOrder4Detail supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStandingOrder4Detail obStandingOrder4Detail = (OBStandingOrder4Detail)o;
        return Objects.equals(this.accountId, obStandingOrder4Detail.accountId) && Objects.equals(this.standingOrderId, obStandingOrder4Detail.standingOrderId) && Objects.equals(this.frequency, obStandingOrder4Detail.frequency) && Objects.equals(this.reference, obStandingOrder4Detail.reference) && Objects.equals(this.firstPaymentDateTime, obStandingOrder4Detail.firstPaymentDateTime) && Objects.equals(this.nextPaymentDateTime, obStandingOrder4Detail.nextPaymentDateTime) && Objects.equals(this.finalPaymentDateTime, obStandingOrder4Detail.finalPaymentDateTime) && Objects.equals((Object)this.standingOrderStatusCode, (Object)obStandingOrder4Detail.standingOrderStatusCode) && Objects.equals(this.firstPaymentAmount, obStandingOrder4Detail.firstPaymentAmount) && Objects.equals(this.nextPaymentAmount, obStandingOrder4Detail.nextPaymentAmount) && Objects.equals(this.finalPaymentAmount, obStandingOrder4Detail.finalPaymentAmount) && Objects.equals(this.creditorAgent, obStandingOrder4Detail.creditorAgent) && Objects.equals(this.creditorAccount, obStandingOrder4Detail.creditorAccount) && Objects.equals(this.supplementaryData, obStandingOrder4Detail.supplementaryData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.standingOrderId, this.frequency, this.reference, this.firstPaymentDateTime, this.nextPaymentDateTime, this.finalPaymentDateTime, this.standingOrderStatusCode, this.firstPaymentAmount, this.nextPaymentAmount, this.finalPaymentAmount, this.creditorAgent, this.creditorAccount, this.supplementaryData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStandingOrder4Detail {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    standingOrderId: ").append(this.toIndentedString(this.standingOrderId)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    firstPaymentDateTime: ").append(this.toIndentedString(this.firstPaymentDateTime)).append("\n");
        sb.append("    nextPaymentDateTime: ").append(this.toIndentedString(this.nextPaymentDateTime)).append("\n");
        sb.append("    finalPaymentDateTime: ").append(this.toIndentedString(this.finalPaymentDateTime)).append("\n");
        sb.append("    standingOrderStatusCode: ").append(this.toIndentedString((Object)this.standingOrderStatusCode)).append("\n");
        sb.append("    firstPaymentAmount: ").append(this.toIndentedString(this.firstPaymentAmount)).append("\n");
        sb.append("    nextPaymentAmount: ").append(this.toIndentedString(this.nextPaymentAmount)).append("\n");
        sb.append("    finalPaymentAmount: ").append(this.toIndentedString(this.finalPaymentAmount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

