/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.account.OBExternalStatementType1Code;
import uk.org.openbanking.datamodel.account.OBStatementAmount1;
import uk.org.openbanking.datamodel.account.OBStatementBenefit1;
import uk.org.openbanking.datamodel.account.OBStatementDateTime1;
import uk.org.openbanking.datamodel.account.OBStatementFee2;
import uk.org.openbanking.datamodel.account.OBStatementInterest2;
import uk.org.openbanking.datamodel.account.OBStatementRate1;
import uk.org.openbanking.datamodel.account.OBStatementValue1;

@ApiModel(description="Provides further details on a statement resource.")
public class OBStatement2 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="StatementId")
    private String statementId = null;
    @JsonProperty(value="StatementReference")
    private String statementReference = null;
    @JsonProperty(value="Type")
    private OBExternalStatementType1Code type = null;
    @JsonProperty(value="StartDateTime")
    private DateTime startDateTime = null;
    @JsonProperty(value="EndDateTime")
    private DateTime endDateTime = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="StatementDescription")
    private List<String> statementDescription = null;
    @JsonProperty(value="StatementBenefit")
    private List<OBStatementBenefit1> statementBenefit = null;
    @JsonProperty(value="StatementFee")
    private List<OBStatementFee2> statementFee = null;
    @JsonProperty(value="StatementInterest")
    private List<OBStatementInterest2> statementInterest = null;
    @JsonProperty(value="StatementDateTime")
    private List<OBStatementDateTime1> statementDateTime = null;
    @JsonProperty(value="StatementRate")
    private List<OBStatementRate1> statementRate = null;
    @JsonProperty(value="StatementValue")
    private List<OBStatementValue1> statementValue = null;
    @JsonProperty(value="StatementAmount")
    private List<OBStatementAmount1> statementAmount = null;

    public OBStatement2 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBStatement2 statementId(String statementId) {
        this.statementId = statementId;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="Unique identifier for the statement resource within an servicing institution. This identifier is both unique and immutable.")
    public String getStatementId() {
        return this.statementId;
    }

    public void setStatementId(String statementId) {
        this.statementId = statementId;
    }

    public OBStatement2 statementReference(String statementReference) {
        this.statementReference = statementReference;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique reference for the statement. This reference may be optionally populated if available.")
    public String getStatementReference() {
        return this.statementReference;
    }

    public void setStatementReference(String statementReference) {
        this.statementReference = statementReference;
    }

    public OBStatement2 type(OBExternalStatementType1Code type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBExternalStatementType1Code getType() {
        return this.type;
    }

    public void setType(OBExternalStatementType1Code type) {
        this.type = type;
    }

    public OBStatement2 startDateTime(DateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the statement period starts. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(DateTime startDateTime) {
        this.startDateTime = startDateTime;
    }

    public OBStatement2 endDateTime(DateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the statement period ends. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(DateTime endDateTime) {
        this.endDateTime = endDateTime;
    }

    public OBStatement2 creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the resource was created. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBStatement2 statementDescription(List<String> statementDescription) {
        this.statementDescription = statementDescription;
        return this;
    }

    public OBStatement2 addStatementDescriptionItem(String statementDescriptionItem) {
        if (this.statementDescription == null) {
            this.statementDescription = new ArrayList<String>();
        }
        this.statementDescription.add(statementDescriptionItem);
        return this;
    }

    @ApiModelProperty(value="Other descriptions that may be available for the statement resource.")
    public List<String> getStatementDescription() {
        return this.statementDescription;
    }

    public void setStatementDescription(List<String> statementDescription) {
        this.statementDescription = statementDescription;
    }

    public OBStatement2 statementBenefit(List<OBStatementBenefit1> statementBenefit) {
        this.statementBenefit = statementBenefit;
        return this;
    }

    public OBStatement2 addStatementBenefitItem(OBStatementBenefit1 statementBenefitItem) {
        if (this.statementBenefit == null) {
            this.statementBenefit = new ArrayList<OBStatementBenefit1>();
        }
        this.statementBenefit.add(statementBenefitItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Set of elements used to provide details of a benefit or reward amount for the statement resource.")
    public List<OBStatementBenefit1> getStatementBenefit() {
        return this.statementBenefit;
    }

    public void setStatementBenefit(List<OBStatementBenefit1> statementBenefit) {
        this.statementBenefit = statementBenefit;
    }

    public OBStatement2 statementFee(List<OBStatementFee2> statementFee) {
        this.statementFee = statementFee;
        return this;
    }

    public OBStatement2 addStatementFeeItem(OBStatementFee2 statementFeeItem) {
        if (this.statementFee == null) {
            this.statementFee = new ArrayList<OBStatementFee2>();
        }
        this.statementFee.add(statementFeeItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Set of elements used to provide details of a fee for the statement resource.")
    public List<OBStatementFee2> getStatementFee() {
        return this.statementFee;
    }

    public void setStatementFee(List<OBStatementFee2> statementFee) {
        this.statementFee = statementFee;
    }

    public OBStatement2 statementInterest(List<OBStatementInterest2> statementInterest) {
        this.statementInterest = statementInterest;
        return this;
    }

    public OBStatement2 addStatementInterestItem(OBStatementInterest2 statementInterestItem) {
        if (this.statementInterest == null) {
            this.statementInterest = new ArrayList<OBStatementInterest2>();
        }
        this.statementInterest.add(statementInterestItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Set of elements used to provide details of a generic interest amount related to the statement resource.")
    public List<OBStatementInterest2> getStatementInterest() {
        return this.statementInterest;
    }

    public void setStatementInterest(List<OBStatementInterest2> statementInterest) {
        this.statementInterest = statementInterest;
    }

    public OBStatement2 statementDateTime(List<OBStatementDateTime1> statementDateTime) {
        this.statementDateTime = statementDateTime;
        return this;
    }

    public OBStatement2 addStatementDateTimeItem(OBStatementDateTime1 statementDateTimeItem) {
        if (this.statementDateTime == null) {
            this.statementDateTime = new ArrayList<OBStatementDateTime1>();
        }
        this.statementDateTime.add(statementDateTimeItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Set of elements used to provide details of a generic date time for the statement resource.")
    public List<OBStatementDateTime1> getStatementDateTime() {
        return this.statementDateTime;
    }

    public void setStatementDateTime(List<OBStatementDateTime1> statementDateTime) {
        this.statementDateTime = statementDateTime;
    }

    public OBStatement2 statementRate(List<OBStatementRate1> statementRate) {
        this.statementRate = statementRate;
        return this;
    }

    public OBStatement2 addStatementRateItem(OBStatementRate1 statementRateItem) {
        if (this.statementRate == null) {
            this.statementRate = new ArrayList<OBStatementRate1>();
        }
        this.statementRate.add(statementRateItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Set of elements used to provide details of a generic rate related to the statement resource.")
    public List<OBStatementRate1> getStatementRate() {
        return this.statementRate;
    }

    public void setStatementRate(List<OBStatementRate1> statementRate) {
        this.statementRate = statementRate;
    }

    public OBStatement2 statementValue(List<OBStatementValue1> statementValue) {
        this.statementValue = statementValue;
        return this;
    }

    public OBStatement2 addStatementValueItem(OBStatementValue1 statementValueItem) {
        if (this.statementValue == null) {
            this.statementValue = new ArrayList<OBStatementValue1>();
        }
        this.statementValue.add(statementValueItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Set of elements used to provide details of a generic number value related to the statement resource.")
    public List<OBStatementValue1> getStatementValue() {
        return this.statementValue;
    }

    public void setStatementValue(List<OBStatementValue1> statementValue) {
        this.statementValue = statementValue;
    }

    public OBStatement2 statementAmount(List<OBStatementAmount1> statementAmount) {
        this.statementAmount = statementAmount;
        return this;
    }

    public OBStatement2 addStatementAmountItem(OBStatementAmount1 statementAmountItem) {
        if (this.statementAmount == null) {
            this.statementAmount = new ArrayList<OBStatementAmount1>();
        }
        this.statementAmount.add(statementAmountItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Set of elements used to provide details of a generic amount for the statement resource.")
    public List<OBStatementAmount1> getStatementAmount() {
        return this.statementAmount;
    }

    public void setStatementAmount(List<OBStatementAmount1> statementAmount) {
        this.statementAmount = statementAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStatement2 obStatement2 = (OBStatement2)o;
        return Objects.equals(this.accountId, obStatement2.accountId) && Objects.equals(this.statementId, obStatement2.statementId) && Objects.equals(this.statementReference, obStatement2.statementReference) && Objects.equals((Object)this.type, (Object)obStatement2.type) && Objects.equals(this.startDateTime, obStatement2.startDateTime) && Objects.equals(this.endDateTime, obStatement2.endDateTime) && Objects.equals(this.creationDateTime, obStatement2.creationDateTime) && Objects.equals(this.statementDescription, obStatement2.statementDescription) && Objects.equals(this.statementBenefit, obStatement2.statementBenefit) && Objects.equals(this.statementFee, obStatement2.statementFee) && Objects.equals(this.statementInterest, obStatement2.statementInterest) && Objects.equals(this.statementDateTime, obStatement2.statementDateTime) && Objects.equals(this.statementRate, obStatement2.statementRate) && Objects.equals(this.statementValue, obStatement2.statementValue) && Objects.equals(this.statementAmount, obStatement2.statementAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.statementId, this.statementReference, this.type, this.startDateTime, this.endDateTime, this.creationDateTime, this.statementDescription, this.statementBenefit, this.statementFee, this.statementInterest, this.statementDateTime, this.statementRate, this.statementValue, this.statementAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStatement2 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    statementId: ").append(this.toIndentedString(this.statementId)).append("\n");
        sb.append("    statementReference: ").append(this.toIndentedString(this.statementReference)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    startDateTime: ").append(this.toIndentedString(this.startDateTime)).append("\n");
        sb.append("    endDateTime: ").append(this.toIndentedString(this.endDateTime)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    statementDescription: ").append(this.toIndentedString(this.statementDescription)).append("\n");
        sb.append("    statementBenefit: ").append(this.toIndentedString(this.statementBenefit)).append("\n");
        sb.append("    statementFee: ").append(this.toIndentedString(this.statementFee)).append("\n");
        sb.append("    statementInterest: ").append(this.toIndentedString(this.statementInterest)).append("\n");
        sb.append("    statementDateTime: ").append(this.toIndentedString(this.statementDateTime)).append("\n");
        sb.append("    statementRate: ").append(this.toIndentedString(this.statementRate)).append("\n");
        sb.append("    statementValue: ").append(this.toIndentedString(this.statementValue)).append("\n");
        sb.append("    statementAmount: ").append(this.toIndentedString(this.statementAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

