/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBActiveOrHistoricCurrencyAndAmount5;
import uk.org.openbanking.datamodel.account.OBCreditDebitCode0;

@ApiModel(description="Set of elements used to provide details of a generic interest amount related to the statement resource.")
public class OBStatement2StatementInterest {
    @JsonProperty(value="Description")
    private String description = null;
    @JsonProperty(value="CreditDebitIndicator")
    private OBCreditDebitCode0 creditDebitIndicator = null;
    @JsonProperty(value="Type")
    private String type = null;
    @JsonProperty(value="Rate")
    private BigDecimal rate = null;
    @JsonProperty(value="RateType")
    private String rateType = null;
    @JsonProperty(value="Frequency")
    private String frequency = null;
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount5 amount = null;

    public OBStatement2StatementInterest description(String description) {
        this.description = description;
        return this;
    }

    @Size(min=1, max=128)
    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OBStatement2StatementInterest creditDebitIndicator(OBCreditDebitCode0 creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBCreditDebitCode0 getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(OBCreditDebitCode0 creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public OBStatement2StatementInterest type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public OBStatement2StatementInterest rate(BigDecimal rate) {
        this.rate = rate;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public OBStatement2StatementInterest rateType(String rateType) {
        this.rateType = rateType;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRateType() {
        return this.rateType;
    }

    public void setRateType(String rateType) {
        this.rateType = rateType;
    }

    public OBStatement2StatementInterest frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(value="")
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public OBStatement2StatementInterest amount(OBActiveOrHistoricCurrencyAndAmount5 amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBActiveOrHistoricCurrencyAndAmount5 getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount5 amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStatement2StatementInterest obStatement2StatementInterest = (OBStatement2StatementInterest)o;
        return Objects.equals(this.description, obStatement2StatementInterest.description) && Objects.equals((Object)this.creditDebitIndicator, (Object)obStatement2StatementInterest.creditDebitIndicator) && Objects.equals(this.type, obStatement2StatementInterest.type) && Objects.equals(this.rate, obStatement2StatementInterest.rate) && Objects.equals(this.rateType, obStatement2StatementInterest.rateType) && Objects.equals(this.frequency, obStatement2StatementInterest.frequency) && Objects.equals(this.amount, obStatement2StatementInterest.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.creditDebitIndicator, this.type, this.rate, this.rateType, this.frequency, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStatement2StatementInterest {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    rateType: ").append(this.toIndentedString(this.rateType)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

