/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Set of elements used to provide details of a generic date time for the statement resource.")
@Validated
public class OBStatementDateTime1 {
    @JsonProperty(value="DateTime")
    private DateTime dateTime = null;
    @JsonProperty(value="Type")
    private String type = null;

    public OBStatementDateTime1 dateTime(DateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time associated with the date time type. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public OBStatementDateTime1 type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Date time type, in a coded form.")
    @NotNull
    @Size(min=1, max=40)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStatementDateTime1 obStatementDateTime1 = (OBStatementDateTime1)o;
        return Objects.equals(this.dateTime, obStatementDateTime1.dateTime) && Objects.equals(this.type, obStatementDateTime1.type);
    }

    public int hashCode() {
        return Objects.hash(this.dateTime, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStatementDateTime1 {\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.dateTime)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

