/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBCreditDebitCode;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@ApiModel(description="Set of elements used to provide details of a fee for the statement resource.")
@Validated
public class OBStatementFee1 {
    @JsonProperty(value="CreditDebitIndicator")
    private OBCreditDebitCode creditDebitIndicator = null;
    @JsonProperty(value="Type")
    private String type = null;
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;

    public OBStatementFee1 creditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the amount is a credit or a debit.  Usage: A zero amount is considered to be a credit amount.")
    @NotNull
    public OBCreditDebitCode getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public OBStatementFee1 type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Fee type, in a coded form.")
    @NotNull
    @Size(min=1, max=40)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public OBStatementFee1 amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStatementFee1 obStatementFee1 = (OBStatementFee1)o;
        return Objects.equals((Object)this.creditDebitIndicator, (Object)obStatementFee1.creditDebitIndicator) && Objects.equals(this.type, obStatementFee1.type) && Objects.equals(this.amount, obStatementFee1.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.creditDebitIndicator, this.type, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStatementFee1 {\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

