/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBActiveOrHistoricCurrencyAndAmount;

@ApiModel(description="Set of elements used to provide details of a fee for the statement resource.")
public class OBStatementFee2 {
    @JsonProperty(value="Description")
    private String description = null;
    @JsonProperty(value="CreditDebitIndicator")
    private CreditDebitIndicatorEnum creditDebitIndicator = null;
    @JsonProperty(value="Type")
    private String type = null;
    @JsonProperty(value="Rate")
    private BigDecimal rate = null;
    @JsonProperty(value="RateType")
    private String rateType = null;
    @JsonProperty(value="Frequency")
    private String frequency = null;
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;

    public OBStatementFee2 description(String description) {
        this.description = description;
        return this;
    }

    @Size(min=1, max=128)
    @ApiModelProperty(value="Description that may be available for the statement fee.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OBStatementFee2 creditDebitIndicator(CreditDebitIndicatorEnum creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Indicates whether the amount is a credit or a debit.  Usage: A zero amount is considered to be a credit amount.")
    public CreditDebitIndicatorEnum getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(CreditDebitIndicatorEnum creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public OBStatementFee2 type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public OBStatementFee2 rate(BigDecimal rate) {
        this.rate = rate;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Rate charged for Statement Fee (where it is charged in terms of a rate rather than an amount)")
    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public OBStatementFee2 rateType(String rateType) {
        this.rateType = rateType;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRateType() {
        return this.rateType;
    }

    public void setRateType(String rateType) {
        this.rateType = rateType;
    }

    public OBStatementFee2 frequency(String frequency) {
        this.frequency = frequency;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="")
    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public OBStatementFee2 amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStatementFee2 obStatementFee2 = (OBStatementFee2)o;
        return Objects.equals(this.description, obStatementFee2.description) && Objects.equals((Object)this.creditDebitIndicator, (Object)obStatementFee2.creditDebitIndicator) && Objects.equals(this.type, obStatementFee2.type) && Objects.equals(this.rate, obStatementFee2.rate) && Objects.equals(this.rateType, obStatementFee2.rateType) && Objects.equals(this.frequency, obStatementFee2.frequency) && Objects.equals(this.amount, obStatementFee2.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.creditDebitIndicator, this.type, this.rate, this.rateType, this.frequency, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStatementFee2 {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    rateType: ").append(this.toIndentedString(this.rateType)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString(this.frequency)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CreditDebitIndicatorEnum {
        CREDIT("Credit"),
        DEBIT("Debit");

        private String value;

        private CreditDebitIndicatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CreditDebitIndicatorEnum fromValue(String text) {
            for (CreditDebitIndicatorEnum b : CreditDebitIndicatorEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

