/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Set of elements used to provide details of a generic rate related to the statement resource.")
@Validated
public class OBStatementRate1 {
    @JsonProperty(value="Rate")
    private String rate = null;
    @JsonProperty(value="Type")
    private String type = null;

    public OBStatementRate1 rate(String rate) {
        this.rate = rate;
        return this;
    }

    @ApiModelProperty(required=true, value="Rate associated with the statement rate type.")
    @NotNull
    @Pattern(regexp="^(-?\\d{1,3}){1}(\\.\\d{1,4}){0,1}$")
    @Size(min=1, max=10)
    public String getRate() {
        return this.rate;
    }

    public void setRate(String rate) {
        this.rate = rate;
    }

    public OBStatementRate1 type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Statement rate type, in a coded form.")
    @NotNull
    @Size(min=1, max=40)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBStatementRate1 obStatementRate1 = (OBStatementRate1)o;
        return Objects.equals(this.rate, obStatementRate1.rate) && Objects.equals(this.type, obStatementRate1.type);
    }

    public int hashCode() {
        return Objects.hash(this.rate, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBStatementRate1 {\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

