/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBInterestCalculationMethod1Code;
import uk.org.openbanking.datamodel.account.OBInterestDestination1Code;
import uk.org.openbanking.datamodel.account.OBTierBand1;
import uk.org.openbanking.datamodel.account.OBTierBandType1Code;

@ApiModel(description="The group of tiers or bands for which credit interest can be applied.")
@Validated
public class OBTierBandSet1 {
    @JsonProperty(value="TierBandMethod")
    private OBTierBandType1Code tierBandMethod = null;
    @JsonProperty(value="CalculationMethod")
    private OBInterestCalculationMethod1Code calculationMethod = null;
    @JsonProperty(value="Destination")
    private OBInterestDestination1Code destination = null;
    @JsonProperty(value="Notes")
    @Valid
    private List<String> notes = null;
    @JsonProperty(value="TierBand")
    @Valid
    private List<OBTierBand1> tierBand = new ArrayList<OBTierBand1>();

    public OBTierBandSet1 tierBandMethod(OBTierBandType1Code tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
        return this;
    }

    @ApiModelProperty(required=true, value="The methodology of how credit interest is paid/applied. It can be:-  1. Banded Interest rates are banded. i.e. Increasing rate on whole balance as balance increases.  2. Tiered Interest rates are tiered. i.e. increasing rate for each tier as balance increases, but interest paid on tier fixed for that tier and not on whole balance.  3. Whole The same interest rate is applied irrespective of the BCA balance")
    @NotNull
    public OBTierBandType1Code getTierBandMethod() {
        return this.tierBandMethod;
    }

    public void setTierBandMethod(OBTierBandType1Code tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
    }

    public OBTierBandSet1 calculationMethod(OBInterestCalculationMethod1Code calculationMethod) {
        this.calculationMethod = calculationMethod;
        return this;
    }

    @ApiModelProperty(value="Methods of calculating interest")
    public OBInterestCalculationMethod1Code getCalculationMethod() {
        return this.calculationMethod;
    }

    public void setCalculationMethod(OBInterestCalculationMethod1Code calculationMethod) {
        this.calculationMethod = calculationMethod;
    }

    public OBTierBandSet1 destination(OBInterestDestination1Code destination) {
        this.destination = destination;
        return this;
    }

    @ApiModelProperty(required=true, value="Describes whether accrued interest is payable only to the BCA or to another bank account")
    @NotNull
    public OBInterestDestination1Code getDestination() {
        return this.destination;
    }

    public void setDestination(OBInterestDestination1Code destination) {
        this.destination = destination;
    }

    public OBTierBandSet1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OBTierBandSet1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Tier Band Set details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OBTierBandSet1 tierBand(List<OBTierBand1> tierBand) {
        this.tierBand = tierBand;
        return this;
    }

    public OBTierBandSet1 addTierBandItem(OBTierBand1 tierBandItem) {
        this.tierBand.add(tierBandItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Tier Band Details")
    @NotNull
    @Valid
    @Size(min=1)
    public List<OBTierBand1> getTierBand() {
        return this.tierBand;
    }

    public void setTierBand(List<OBTierBand1> tierBand) {
        this.tierBand = tierBand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBTierBandSet1 creditInterest1TierBandSet = (OBTierBandSet1)o;
        return Objects.equals((Object)this.tierBandMethod, (Object)creditInterest1TierBandSet.tierBandMethod) && Objects.equals((Object)this.calculationMethod, (Object)creditInterest1TierBandSet.calculationMethod) && Objects.equals((Object)this.destination, (Object)creditInterest1TierBandSet.destination) && Objects.equals(this.notes, creditInterest1TierBandSet.notes) && Objects.equals(this.tierBand, creditInterest1TierBandSet.tierBand);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierBandMethod, this.calculationMethod, this.destination, this.notes, this.tierBand});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBTierBandSet1 {\n");
        sb.append("    tierBandMethod: ").append(this.toIndentedString((Object)this.tierBandMethod)).append("\n");
        sb.append("    calculationMethod: ").append(this.toIndentedString((Object)this.calculationMethod)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString((Object)this.destination)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    tierBand: ").append(this.toIndentedString(this.tierBand)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

