/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBBankTransactionCodeStructure1;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification2;
import uk.org.openbanking.datamodel.account.OBCashAccount2;
import uk.org.openbanking.datamodel.account.OBCreditDebitCode;
import uk.org.openbanking.datamodel.account.OBEntryStatus1Code;
import uk.org.openbanking.datamodel.account.OBEquivalentAmount;
import uk.org.openbanking.datamodel.account.OBMerchantDetails1;
import uk.org.openbanking.datamodel.account.OBTransactionCardInstrument1;
import uk.org.openbanking.datamodel.account.OBTransactionCashBalance;
import uk.org.openbanking.datamodel.account.ProprietaryBankTransactionCodeStructure1;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.jackson.DateTimeDeserializer;
import uk.org.openbanking.jackson.DateTimeSerializer;

@ApiModel(description="Provides further details on an entry in the report.")
@Validated
public class OBTransaction2 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="TransactionId")
    private String transactionId = null;
    @JsonProperty(value="TransactionReference")
    private String transactionReference = null;
    @JsonProperty(value="StatementReference")
    @Valid
    private List<String> statementReference = null;
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;
    @JsonProperty(value="CreditDebitIndicator")
    private OBCreditDebitCode creditDebitIndicator = null;
    @JsonProperty(value="Status")
    private OBEntryStatus1Code status = null;
    @JsonProperty(value="BookingDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime bookingDateTime = null;
    @JsonProperty(value="ValueDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime valueDateTime = null;
    @JsonProperty(value="AddressLine")
    private String addressLine = null;
    @JsonProperty(value="BankTransactionCode")
    private OBBankTransactionCodeStructure1 bankTransactionCode = null;
    @JsonProperty(value="ProprietaryBankTransactionCode")
    private ProprietaryBankTransactionCodeStructure1 proprietaryBankTransactionCode = null;
    @JsonProperty(value="EquivalentAmount")
    private OBEquivalentAmount equivalentAmount = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification2 creditorAgent = null;
    @JsonProperty(value="DebtorAgent")
    private OBBranchAndFinancialInstitutionIdentification2 debtorAgent = null;
    @JsonProperty(value="CardInstrument")
    private OBTransactionCardInstrument1 cardInstrument = null;
    @JsonProperty(value="TransactionInformation")
    private String transactionInformation = null;
    @JsonProperty(value="Balance")
    private OBTransactionCashBalance balance = null;
    @JsonProperty(value="MerchantDetails")
    private OBMerchantDetails1 merchantDetails = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount2 creditorAccount = null;
    @JsonProperty(value="DebtorAccount")
    private OBBranchAndFinancialInstitutionIdentification2 debtorAccount = null;

    public OBTransaction2 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique and immutable identifier used to identify the account resource. This identifier has no meaning to the account owner.")
    @NotNull
    @Size(min=1, max=40)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBTransaction2 transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier for the transaction within an servicing institution. This identifier is both unique and immutable.")
    @Size(min=1, max=40)
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public OBTransaction2 transactionReference(String transactionReference) {
        this.transactionReference = transactionReference;
        return this;
    }

    @ApiModelProperty(value="Unique reference for the transaction. This reference is optionally populated, and may as an example be the FPID in the Faster Payments context.")
    @Size(min=1, max=35)
    public String getTransactionReference() {
        return this.transactionReference;
    }

    public void setTransactionReference(String transactionReference) {
        this.transactionReference = transactionReference;
    }

    public OBTransaction2 statementReference(List<String> statementReference) {
        this.statementReference = statementReference;
        return this;
    }

    public OBTransaction2 addStatementReferenceItem(String statementReferenceItem) {
        if (this.statementReference == null) {
            this.statementReference = new ArrayList<String>();
        }
        this.statementReference.add(statementReferenceItem);
        return this;
    }

    @ApiModelProperty(value="Unique reference for the statement. This reference may be optionally populated if available.")
    public List<String> getStatementReference() {
        return this.statementReference;
    }

    public void setStatementReference(List<String> statementReference) {
        this.statementReference = statementReference;
    }

    public OBTransaction2 amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public OBTransaction2 creditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the transaction is a credit or a debit entry.")
    @NotNull
    public OBCreditDebitCode getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public OBTransaction2 status(OBEntryStatus1Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of a transaction entry on the books of the account servicer.")
    @NotNull
    public OBEntryStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBEntryStatus1Code status) {
        this.status = status;
    }

    public OBTransaction2 bookingDateTime(DateTime bookingDateTime) {
        this.bookingDateTime = bookingDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time when a transaction entry is posted to an account on the account servicer's books. Usage: Booking date is the expected booking date, unless the status is booked, in which case it is the actual booking date. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getBookingDateTime() {
        return this.bookingDateTime;
    }

    public void setBookingDateTime(DateTime bookingDateTime) {
        this.bookingDateTime = bookingDateTime;
    }

    public OBTransaction2 valueDateTime(DateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time at which assets become available to the account owner in case of a credit entry, or cease to be available to the account owner in case of a debit transaction entry. Usage: If transaction entry status is pending and value date is present, then the value date refers to an expected/requested value date. For transaction entries subject to availability/float and for which availability information is provided, the value date must not be used. In this case the availability component identifies the number of availability days. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getValueDateTime() {
        return this.valueDateTime;
    }

    public void setValueDateTime(DateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
    }

    public OBTransaction2 addressLine(String addressLine) {
        this.addressLine = addressLine;
        return this;
    }

    @ApiModelProperty(value="Information that locates and identifies a specific address for a transaction entry, that is presented in free format text.")
    @Size(min=1, max=70)
    public String getAddressLine() {
        return this.addressLine;
    }

    public void setAddressLine(String addressLine) {
        this.addressLine = addressLine;
    }

    public OBTransaction2 bankTransactionCode(OBBankTransactionCodeStructure1 bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBankTransactionCodeStructure1 getBankTransactionCode() {
        return this.bankTransactionCode;
    }

    public void setBankTransactionCode(OBBankTransactionCodeStructure1 bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
    }

    public OBTransaction2 proprietaryBankTransactionCode(ProprietaryBankTransactionCodeStructure1 proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public ProprietaryBankTransactionCodeStructure1 getProprietaryBankTransactionCode() {
        return this.proprietaryBankTransactionCode;
    }

    public void setProprietaryBankTransactionCode(ProprietaryBankTransactionCodeStructure1 proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
    }

    public OBTransaction2 equivalentAmount(OBEquivalentAmount equivalentAmount) {
        this.equivalentAmount = equivalentAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBEquivalentAmount getEquivalentAmount() {
        return this.equivalentAmount;
    }

    public void setEquivalentAmount(OBEquivalentAmount equivalentAmount) {
        this.equivalentAmount = equivalentAmount;
    }

    public OBTransaction2 creditorAgent(OBBranchAndFinancialInstitutionIdentification2 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification2 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification2 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBTransaction2 debtorAgent(OBBranchAndFinancialInstitutionIdentification2 debtorAgent) {
        this.debtorAgent = debtorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification2 getDebtorAgent() {
        return this.debtorAgent;
    }

    public void setDebtorAgent(OBBranchAndFinancialInstitutionIdentification2 debtorAgent) {
        this.debtorAgent = debtorAgent;
    }

    public OBTransaction2 cardInstrument(OBTransactionCardInstrument1 cardInstrument) {
        this.cardInstrument = cardInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBTransactionCardInstrument1 getCardInstrument() {
        return this.cardInstrument;
    }

    public void setCardInstrument(OBTransactionCardInstrument1 cardInstrument) {
        this.cardInstrument = cardInstrument;
    }

    public OBTransaction2 transactionInformation(String transactionInformation) {
        this.transactionInformation = transactionInformation;
        return this;
    }

    @ApiModelProperty(value="Further details of the transaction.  This is the transaction narrative, which is unstructured text.")
    @Size(min=1, max=500)
    public String getTransactionInformation() {
        return this.transactionInformation;
    }

    public void setTransactionInformation(String transactionInformation) {
        this.transactionInformation = transactionInformation;
    }

    public OBTransaction2 balance(OBTransactionCashBalance balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBTransactionCashBalance getBalance() {
        return this.balance;
    }

    public void setBalance(OBTransactionCashBalance balance) {
        this.balance = balance;
    }

    public OBTransaction2 merchantDetails(OBMerchantDetails1 merchantDetails) {
        this.merchantDetails = merchantDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBMerchantDetails1 getMerchantDetails() {
        return this.merchantDetails;
    }

    public void setMerchantDetails(OBMerchantDetails1 merchantDetails) {
        this.merchantDetails = merchantDetails;
    }

    public OBTransaction2 creditorAccount(OBCashAccount2 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount2 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount2 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBTransaction2 debtorAccount(OBBranchAndFinancialInstitutionIdentification2 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification2 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBBranchAndFinancialInstitutionIdentification2 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBTransaction2 obTransaction2 = (OBTransaction2)o;
        return Objects.equals(this.accountId, obTransaction2.accountId) && Objects.equals(this.transactionId, obTransaction2.transactionId) && Objects.equals(this.transactionReference, obTransaction2.transactionReference) && Objects.equals(this.statementReference, obTransaction2.statementReference) && Objects.equals(this.amount, obTransaction2.amount) && Objects.equals((Object)this.creditDebitIndicator, (Object)obTransaction2.creditDebitIndicator) && Objects.equals((Object)this.status, (Object)obTransaction2.status) && Objects.equals(this.bookingDateTime, obTransaction2.bookingDateTime) && Objects.equals(this.valueDateTime, obTransaction2.valueDateTime) && Objects.equals(this.addressLine, obTransaction2.addressLine) && Objects.equals(this.bankTransactionCode, obTransaction2.bankTransactionCode) && Objects.equals(this.proprietaryBankTransactionCode, obTransaction2.proprietaryBankTransactionCode) && Objects.equals(this.equivalentAmount, obTransaction2.equivalentAmount) && Objects.equals(this.creditorAgent, obTransaction2.creditorAgent) && Objects.equals(this.debtorAgent, obTransaction2.debtorAgent) && Objects.equals(this.cardInstrument, obTransaction2.cardInstrument) && Objects.equals(this.transactionInformation, obTransaction2.transactionInformation) && Objects.equals(this.balance, obTransaction2.balance) && Objects.equals(this.merchantDetails, obTransaction2.merchantDetails) && Objects.equals(this.creditorAccount, obTransaction2.creditorAccount) && Objects.equals(this.debtorAccount, obTransaction2.debtorAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.transactionId, this.transactionReference, this.statementReference, this.amount, this.creditDebitIndicator, this.status, this.bookingDateTime, this.valueDateTime, this.addressLine, this.bankTransactionCode, this.proprietaryBankTransactionCode, this.equivalentAmount, this.creditorAgent, this.debtorAgent, this.cardInstrument, this.transactionInformation, this.balance, this.merchantDetails, this.creditorAccount, this.debtorAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBTransaction2 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionReference: ").append(this.toIndentedString(this.transactionReference)).append("\n");
        sb.append("    statementReference: ").append(this.toIndentedString(this.statementReference)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    bookingDateTime: ").append(this.toIndentedString(this.bookingDateTime)).append("\n");
        sb.append("    valueDateTime: ").append(this.toIndentedString(this.valueDateTime)).append("\n");
        sb.append("    addressLine: ").append(this.toIndentedString(this.addressLine)).append("\n");
        sb.append("    bankTransactionCode: ").append(this.toIndentedString(this.bankTransactionCode)).append("\n");
        sb.append("    proprietaryBankTransactionCode: ").append(this.toIndentedString(this.proprietaryBankTransactionCode)).append("\n");
        sb.append("    equivalentAmount: ").append(this.toIndentedString(this.equivalentAmount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    debtorAgent: ").append(this.toIndentedString(this.debtorAgent)).append("\n");
        sb.append("    cardInstrument: ").append(this.toIndentedString(this.cardInstrument)).append("\n");
        sb.append("    transactionInformation: ").append(this.toIndentedString(this.transactionInformation)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    merchantDetails: ").append(this.toIndentedString(this.merchantDetails)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

