/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBBankTransactionCodeStructure1;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification3;
import uk.org.openbanking.datamodel.account.OBCashAccount3;
import uk.org.openbanking.datamodel.account.OBCreditDebitCode;
import uk.org.openbanking.datamodel.account.OBCurrencyExchange5;
import uk.org.openbanking.datamodel.account.OBEntryStatus1Code;
import uk.org.openbanking.datamodel.account.OBMerchantDetails1;
import uk.org.openbanking.datamodel.account.OBTransaction3ProprietaryBankTransactionCode;
import uk.org.openbanking.datamodel.account.OBTransactionCardInstrument1;
import uk.org.openbanking.datamodel.account.OBTransactionCashBalance;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@ApiModel(description="Provides further details on an entry in the report.")
@Validated
public class OBTransaction3 {
    @JsonProperty(value="AccountId")
    private String accountId = null;
    @JsonProperty(value="TransactionId")
    private String transactionId = null;
    @JsonProperty(value="TransactionReference")
    private String transactionReference = null;
    @JsonProperty(value="StatementReference")
    @Valid
    private List<String> statementReference = null;
    @JsonProperty(value="CreditDebitIndicator")
    private OBCreditDebitCode creditDebitIndicator = null;
    @JsonProperty(value="Status")
    private OBEntryStatus1Code status = null;
    @JsonProperty(value="BookingDateTime")
    private DateTime bookingDateTime = null;
    @JsonProperty(value="ValueDateTime")
    private DateTime valueDateTime = null;
    @JsonProperty(value="AddressLine")
    private String addressLine = null;
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;
    @JsonProperty(value="ChargeAmount")
    private OBActiveOrHistoricCurrencyAndAmount chargeAmount = null;
    @JsonProperty(value="CurrencyExchange")
    private OBCurrencyExchange5 currencyExchange = null;
    @JsonProperty(value="BankTransactionCode")
    private OBBankTransactionCodeStructure1 bankTransactionCode = null;
    @JsonProperty(value="ProprietaryBankTransactionCode")
    private OBTransaction3ProprietaryBankTransactionCode proprietaryBankTransactionCode = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification3 creditorAgent = null;
    @JsonProperty(value="DebtorAgent")
    private OBBranchAndFinancialInstitutionIdentification3 debtorAgent = null;
    @JsonProperty(value="DebtorAccount")
    private OBCashAccount3 debtorAccount = null;
    @JsonProperty(value="CardInstrument")
    private OBTransactionCardInstrument1 cardInstrument = null;
    @JsonProperty(value="TransactionInformation")
    private String transactionInformation = null;
    @JsonProperty(value="Balance")
    private OBTransactionCashBalance balance = null;
    @JsonProperty(value="MerchantDetails")
    private OBMerchantDetails1 merchantDetails = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount3 creditorAccount = null;

    public OBTransaction3 accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public OBTransaction3 transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier for the transaction within an servicing institution. This identifier is both unique and immutable.")
    @Size(min=1, max=40)
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public OBTransaction3 transactionReference(String transactionReference) {
        this.transactionReference = transactionReference;
        return this;
    }

    @ApiModelProperty(value="Unique reference for the transaction. This reference is optionally populated, and may as an example be the FPID in the Faster Payments context.")
    @Size(min=1, max=35)
    public String getTransactionReference() {
        return this.transactionReference;
    }

    public void setTransactionReference(String transactionReference) {
        this.transactionReference = transactionReference;
    }

    public OBTransaction3 statementReference(List<String> statementReference) {
        this.statementReference = statementReference;
        return this;
    }

    public OBTransaction3 addStatementReferenceItem(String statementReferenceItem) {
        if (this.statementReference == null) {
            this.statementReference = new ArrayList<String>();
        }
        this.statementReference.add(statementReferenceItem);
        return this;
    }

    @ApiModelProperty(value="Unique reference for the statement. This reference may be optionally populated if available.")
    public List<String> getStatementReference() {
        return this.statementReference;
    }

    public void setStatementReference(List<String> statementReference) {
        this.statementReference = statementReference;
    }

    public OBTransaction3 creditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the transaction is a credit or a debit entry.")
    @NotNull
    public OBCreditDebitCode getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public OBTransaction3 status(OBEntryStatus1Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBEntryStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBEntryStatus1Code status) {
        this.status = status;
    }

    public OBTransaction3 bookingDateTime(DateTime bookingDateTime) {
        this.bookingDateTime = bookingDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time when a transaction entry is posted to an account on the account servicer's books. Usage: Booking date is the expected booking date, unless the status is booked, in which case it is the actual booking date. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getBookingDateTime() {
        return this.bookingDateTime;
    }

    public void setBookingDateTime(DateTime bookingDateTime) {
        this.bookingDateTime = bookingDateTime;
    }

    public OBTransaction3 valueDateTime(DateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
        return this;
    }

    @ApiModelProperty(value="Date and time at which assets become available to the account owner in case of a credit entry, or cease to be available to the account owner in case of a debit transaction entry. Usage: If transaction entry status is pending and value date is present, then the value date refers to an expected/requested value date. For transaction entries subject to availability/float and for which availability information is provided, the value date must not be used. In this case the availability component identifies the number of availability days. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getValueDateTime() {
        return this.valueDateTime;
    }

    public void setValueDateTime(DateTime valueDateTime) {
        this.valueDateTime = valueDateTime;
    }

    public OBTransaction3 addressLine(String addressLine) {
        this.addressLine = addressLine;
        return this;
    }

    @ApiModelProperty(value="Information that locates and identifies a specific address for a transaction entry, that is presented in free format text.")
    @Size(min=1, max=70)
    public String getAddressLine() {
        return this.addressLine;
    }

    public void setAddressLine(String addressLine) {
        this.addressLine = addressLine;
    }

    public OBTransaction3 amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public OBTransaction3 chargeAmount(OBActiveOrHistoricCurrencyAndAmount chargeAmount) {
        this.chargeAmount = chargeAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getChargeAmount() {
        return this.chargeAmount;
    }

    public void setChargeAmount(OBActiveOrHistoricCurrencyAndAmount chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    public OBTransaction3 currencyExchange(OBCurrencyExchange5 currencyExchange) {
        this.currencyExchange = currencyExchange;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCurrencyExchange5 getCurrencyExchange() {
        return this.currencyExchange;
    }

    public void setCurrencyExchange(OBCurrencyExchange5 currencyExchange) {
        this.currencyExchange = currencyExchange;
    }

    public OBTransaction3 bankTransactionCode(OBBankTransactionCodeStructure1 bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBankTransactionCodeStructure1 getBankTransactionCode() {
        return this.bankTransactionCode;
    }

    public void setBankTransactionCode(OBBankTransactionCodeStructure1 bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
    }

    public OBTransaction3 proprietaryBankTransactionCode(OBTransaction3ProprietaryBankTransactionCode proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBTransaction3ProprietaryBankTransactionCode getProprietaryBankTransactionCode() {
        return this.proprietaryBankTransactionCode;
    }

    public void setProprietaryBankTransactionCode(OBTransaction3ProprietaryBankTransactionCode proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
    }

    public OBTransaction3 creditorAgent(OBBranchAndFinancialInstitutionIdentification3 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification3 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification3 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBTransaction3 debtorAgent(OBBranchAndFinancialInstitutionIdentification3 debtorAgent) {
        this.debtorAgent = debtorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification3 getDebtorAgent() {
        return this.debtorAgent;
    }

    public void setDebtorAgent(OBBranchAndFinancialInstitutionIdentification3 debtorAgent) {
        this.debtorAgent = debtorAgent;
    }

    public OBTransaction3 debtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount3 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBTransaction3 cardInstrument(OBTransactionCardInstrument1 cardInstrument) {
        this.cardInstrument = cardInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBTransactionCardInstrument1 getCardInstrument() {
        return this.cardInstrument;
    }

    public void setCardInstrument(OBTransactionCardInstrument1 cardInstrument) {
        this.cardInstrument = cardInstrument;
    }

    public OBTransaction3 transactionInformation(String transactionInformation) {
        this.transactionInformation = transactionInformation;
        return this;
    }

    @ApiModelProperty(value="")
    public String getTransactionInformation() {
        return this.transactionInformation;
    }

    public void setTransactionInformation(String transactionInformation) {
        this.transactionInformation = transactionInformation;
    }

    public OBTransaction3 balance(OBTransactionCashBalance balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBTransactionCashBalance getBalance() {
        return this.balance;
    }

    public void setBalance(OBTransactionCashBalance balance) {
        this.balance = balance;
    }

    public OBTransaction3 merchantDetails(OBMerchantDetails1 merchantDetails) {
        this.merchantDetails = merchantDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBMerchantDetails1 getMerchantDetails() {
        return this.merchantDetails;
    }

    public void setMerchantDetails(OBMerchantDetails1 merchantDetails) {
        this.merchantDetails = merchantDetails;
    }

    public OBTransaction3 creditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount3 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBTransaction3 obTransaction3 = (OBTransaction3)o;
        return Objects.equals(this.accountId, obTransaction3.accountId) && Objects.equals(this.transactionId, obTransaction3.transactionId) && Objects.equals(this.transactionReference, obTransaction3.transactionReference) && Objects.equals(this.statementReference, obTransaction3.statementReference) && Objects.equals((Object)this.creditDebitIndicator, (Object)obTransaction3.creditDebitIndicator) && Objects.equals((Object)this.status, (Object)obTransaction3.status) && Objects.equals(this.bookingDateTime, obTransaction3.bookingDateTime) && Objects.equals(this.valueDateTime, obTransaction3.valueDateTime) && Objects.equals(this.addressLine, obTransaction3.addressLine) && Objects.equals(this.amount, obTransaction3.amount) && Objects.equals(this.chargeAmount, obTransaction3.chargeAmount) && Objects.equals(this.currencyExchange, obTransaction3.currencyExchange) && Objects.equals(this.bankTransactionCode, obTransaction3.bankTransactionCode) && Objects.equals(this.proprietaryBankTransactionCode, obTransaction3.proprietaryBankTransactionCode) && Objects.equals(this.creditorAgent, obTransaction3.creditorAgent) && Objects.equals(this.debtorAgent, obTransaction3.debtorAgent) && Objects.equals(this.debtorAccount, obTransaction3.debtorAccount) && Objects.equals(this.cardInstrument, obTransaction3.cardInstrument) && Objects.equals(this.transactionInformation, obTransaction3.transactionInformation) && Objects.equals(this.balance, obTransaction3.balance) && Objects.equals(this.merchantDetails, obTransaction3.merchantDetails) && Objects.equals(this.creditorAccount, obTransaction3.creditorAccount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.transactionId, this.transactionReference, this.statementReference, this.creditDebitIndicator, this.status, this.bookingDateTime, this.valueDateTime, this.addressLine, this.amount, this.chargeAmount, this.currencyExchange, this.bankTransactionCode, this.proprietaryBankTransactionCode, this.creditorAgent, this.debtorAgent, this.debtorAccount, this.cardInstrument, this.transactionInformation, this.balance, this.merchantDetails, this.creditorAccount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBTransaction3 {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    transactionReference: ").append(this.toIndentedString(this.transactionReference)).append("\n");
        sb.append("    statementReference: ").append(this.toIndentedString(this.statementReference)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    bookingDateTime: ").append(this.toIndentedString(this.bookingDateTime)).append("\n");
        sb.append("    valueDateTime: ").append(this.toIndentedString(this.valueDateTime)).append("\n");
        sb.append("    addressLine: ").append(this.toIndentedString(this.addressLine)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    chargeAmount: ").append(this.toIndentedString(this.chargeAmount)).append("\n");
        sb.append("    currencyExchange: ").append(this.toIndentedString(this.currencyExchange)).append("\n");
        sb.append("    bankTransactionCode: ").append(this.toIndentedString(this.bankTransactionCode)).append("\n");
        sb.append("    proprietaryBankTransactionCode: ").append(this.toIndentedString(this.proprietaryBankTransactionCode)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    debtorAgent: ").append(this.toIndentedString(this.debtorAgent)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    cardInstrument: ").append(this.toIndentedString(this.cardInstrument)).append("\n");
        sb.append("    transactionInformation: ").append(this.toIndentedString(this.transactionInformation)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    merchantDetails: ").append(this.toIndentedString(this.merchantDetails)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

