/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import uk.org.openbanking.datamodel.account.OBBalanceType1Code;
import uk.org.openbanking.datamodel.account.OBCreditDebitCode;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;

@ApiModel(description="Set of elements used to define the balance as a numerical representation of the net increases and decreases in an account after a transaction entry is applied to the account.")
public class OBTransactionCashBalance {
    @JsonProperty(value="Amount")
    private OBActiveOrHistoricCurrencyAndAmount amount = null;
    @JsonProperty(value="CreditDebitIndicator")
    private OBCreditDebitCode creditDebitIndicator = null;
    @JsonProperty(value="Type")
    private OBBalanceType1Code type = null;

    public OBTransactionCashBalance amount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getAmount() {
        return this.amount;
    }

    public void setAmount(OBActiveOrHistoricCurrencyAndAmount amount) {
        this.amount = amount;
    }

    public OBTransactionCashBalance creditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the balance is a credit or a debit balance. Usage: A zero balance is considered to be a credit balance.")
    @NotNull
    public OBCreditDebitCode getCreditDebitIndicator() {
        return this.creditDebitIndicator;
    }

    public void setCreditDebitIndicator(OBCreditDebitCode creditDebitIndicator) {
        this.creditDebitIndicator = creditDebitIndicator;
    }

    public OBTransactionCashBalance type(OBBalanceType1Code type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Balance type, in a coded form.")
    @NotNull
    public OBBalanceType1Code getType() {
        return this.type;
    }

    public void setType(OBBalanceType1Code type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBTransactionCashBalance data3Balance = (OBTransactionCashBalance)o;
        return Objects.equals(this.amount, data3Balance.amount) && Objects.equals((Object)this.creditDebitIndicator, (Object)data3Balance.creditDebitIndicator) && Objects.equals((Object)this.type, (Object)data3Balance.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.creditDebitIndicator, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Data3Balance {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    creditDebitIndicator: ").append(this.toIndentedString((Object)this.creditDebitIndicator)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

