/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@ApiModel(description="Other interest rate types which are not available in the standard code list")
public class OtherBankInterestType {
    @JsonProperty(value="Code")
    private String code = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="Description")
    private String description = null;

    public OtherBankInterestType code(String code) {
        this.code = code;
        return this;
    }

    @Pattern(regexp="^\\w{0,4}$")
    @Size(min=0, max=4)
    @ApiModelProperty(value="The four letter Mnemonic used within an XML file to identify a code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public OtherBankInterestType name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Size(min=1, max=70)
    @ApiModelProperty(required=true, value="Long name associated with the code")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OtherBankInterestType description(String description) {
        this.description = description;
        return this;
    }

    @NotNull
    @Size(min=1, max=350)
    @ApiModelProperty(required=true, value="Description to describe the purpose of the code")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtherBankInterestType otherBankInterestType = (OtherBankInterestType)o;
        return Objects.equals(this.code, otherBankInterestType.code) && Objects.equals(this.name, otherBankInterestType.name) && Objects.equals(this.description, otherBankInterestType.description);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.name, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtherBankInterestType {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

