/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OverdraftOtherFeeType;

@ApiModel(description="Details about any caps (maximum charges) that apply to a particular fee/charge")
public class OtherFeesChargesFeeChargeCap {
    @JsonProperty(value="FeeType")
    private List<FeeTypeEnum> feeType = new ArrayList<FeeTypeEnum>();
    @JsonProperty(value="MinMaxType")
    private MinMaxTypeEnum minMaxType = null;
    @JsonProperty(value="FeeCapOccurrence")
    private Float feeCapOccurrence = null;
    @JsonProperty(value="FeeCapAmount")
    private String feeCapAmount = null;
    @JsonProperty(value="CappingPeriod")
    private CappingPeriodEnum cappingPeriod = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OtherFeeType")
    private List<OverdraftOtherFeeType> otherFeeType = null;

    public OtherFeesChargesFeeChargeCap feeType(List<FeeTypeEnum> feeType) {
        this.feeType = feeType;
        return this;
    }

    public OtherFeesChargesFeeChargeCap addFeeTypeItem(FeeTypeEnum feeTypeItem) {
        this.feeType.add(feeTypeItem);
        return this;
    }

    @NotNull
    @Size(min=1)
    @ApiModelProperty(required=true, value="Fee/charge type which is being capped")
    public List<FeeTypeEnum> getFeeType() {
        return this.feeType;
    }

    public void setFeeType(List<FeeTypeEnum> feeType) {
        this.feeType = feeType;
    }

    public OtherFeesChargesFeeChargeCap minMaxType(MinMaxTypeEnum minMaxType) {
        this.minMaxType = minMaxType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Indicates that this is the minimum/ maximum fee/charge that can be applied by the financial institution")
    public MinMaxTypeEnum getMinMaxType() {
        return this.minMaxType;
    }

    public void setMinMaxType(MinMaxTypeEnum minMaxType) {
        this.minMaxType = minMaxType;
    }

    public OtherFeesChargesFeeChargeCap feeCapOccurrence(Float feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
        return this;
    }

    @ApiModelProperty(value="fee/charges are captured dependent on the number of occurrences rather than capped at a particular amount")
    public Float getFeeCapOccurrence() {
        return this.feeCapOccurrence;
    }

    public void setFeeCapOccurrence(Float feeCapOccurrence) {
        this.feeCapOccurrence = feeCapOccurrence;
    }

    public OtherFeesChargesFeeChargeCap feeCapAmount(String feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="Cap amount charged for a fee/charge (where it is charged in terms of an amount rather than a rate)")
    public String getFeeCapAmount() {
        return this.feeCapAmount;
    }

    public void setFeeCapAmount(String feeCapAmount) {
        this.feeCapAmount = feeCapAmount;
    }

    public OtherFeesChargesFeeChargeCap cappingPeriod(CappingPeriodEnum cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
        return this;
    }

    @ApiModelProperty(value="Period e.g. day, week, month etc. for which the fee/charge is capped")
    public CappingPeriodEnum getCappingPeriod() {
        return this.cappingPeriod;
    }

    public void setCappingPeriod(CappingPeriodEnum cappingPeriod) {
        this.cappingPeriod = cappingPeriod;
    }

    public OtherFeesChargesFeeChargeCap notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public OtherFeesChargesFeeChargeCap addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Free text for adding  extra details for fee charge cap")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public OtherFeesChargesFeeChargeCap otherFeeType(List<OverdraftOtherFeeType> otherFeeType) {
        this.otherFeeType = otherFeeType;
        return this;
    }

    public OtherFeesChargesFeeChargeCap addOtherFeeTypeItem(OverdraftOtherFeeType otherFeeTypeItem) {
        if (this.otherFeeType == null) {
            this.otherFeeType = new ArrayList<OverdraftOtherFeeType>();
        }
        this.otherFeeType.add(otherFeeTypeItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Other fee type code which is not available in the standard code set")
    public List<OverdraftOtherFeeType> getOtherFeeType() {
        return this.otherFeeType;
    }

    public void setOtherFeeType(List<OverdraftOtherFeeType> otherFeeType) {
        this.otherFeeType = otherFeeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtherFeesChargesFeeChargeCap otherFeesChargesFeeChargeCap = (OtherFeesChargesFeeChargeCap)o;
        return Objects.equals(this.feeType, otherFeesChargesFeeChargeCap.feeType) && Objects.equals((Object)this.minMaxType, (Object)otherFeesChargesFeeChargeCap.minMaxType) && Objects.equals(this.feeCapOccurrence, otherFeesChargesFeeChargeCap.feeCapOccurrence) && Objects.equals(this.feeCapAmount, otherFeesChargesFeeChargeCap.feeCapAmount) && Objects.equals((Object)this.cappingPeriod, (Object)otherFeesChargesFeeChargeCap.cappingPeriod) && Objects.equals(this.notes, otherFeesChargesFeeChargeCap.notes) && Objects.equals(this.otherFeeType, otherFeesChargesFeeChargeCap.otherFeeType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.feeType, this.minMaxType, this.feeCapOccurrence, this.feeCapAmount, this.cappingPeriod, this.notes, this.otherFeeType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtherFeesChargesFeeChargeCap {\n");
        sb.append("    feeType: ").append(this.toIndentedString(this.feeType)).append("\n");
        sb.append("    minMaxType: ").append(this.toIndentedString((Object)this.minMaxType)).append("\n");
        sb.append("    feeCapOccurrence: ").append(this.toIndentedString(this.feeCapOccurrence)).append("\n");
        sb.append("    feeCapAmount: ").append(this.toIndentedString(this.feeCapAmount)).append("\n");
        sb.append("    cappingPeriod: ").append(this.toIndentedString((Object)this.cappingPeriod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    otherFeeType: ").append(this.toIndentedString(this.otherFeeType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CappingPeriodEnum {
        ACADEMICTERM("AcademicTerm"),
        DAY("Day"),
        HALF_YEAR("Half Year"),
        MONTH("Month"),
        QUARTER("Quarter"),
        WEEK("Week"),
        YEAR("Year");

        private String value;

        private CappingPeriodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CappingPeriodEnum fromValue(String text) {
            for (CappingPeriodEnum b : CappingPeriodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum MinMaxTypeEnum {
        MINIMUM("Minimum"),
        MAXIMUM("Maximum");

        private String value;

        private MinMaxTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MinMaxTypeEnum fromValue(String text) {
            for (MinMaxTypeEnum b : MinMaxTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FeeTypeEnum {
        SERVICECACCOUNTFEE("ServiceCAccountFee"),
        SERVICECACCOUNTFEEMONTHLY("ServiceCAccountFeeMonthly"),
        SERVICECOTHER("ServiceCOther"),
        OTHER("Other");

        private String value;

        private FeeTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeTypeEnum fromValue(String text) {
            for (FeeTypeEnum b : FeeTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

