/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.Overdraft1OverdraftFeesCharges1;
import uk.org.openbanking.datamodel.account.Overdraft1OverdraftTierBand;

@ApiModel(description="Tier band set details")
public class Overdraft1OverdraftTierBandSet {
    @JsonProperty(value="TierBandMethod")
    private TierBandMethodEnum tierBandMethod = null;
    @JsonProperty(value="OverdraftType")
    private OverdraftTypeEnum overdraftType = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="AuthorisedIndicator")
    private Boolean authorisedIndicator = null;
    @JsonProperty(value="BufferAmount")
    private String bufferAmount = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;
    @JsonProperty(value="OverdraftTierBand")
    private List<Overdraft1OverdraftTierBand> overdraftTierBand = new ArrayList<Overdraft1OverdraftTierBand>();
    @JsonProperty(value="OverdraftFeesCharges")
    private List<Overdraft1OverdraftFeesCharges1> overdraftFeesCharges = null;

    public Overdraft1OverdraftTierBandSet tierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="The methodology of how overdraft is charged. It can be: 'Whole'  Where the same charge/rate is applied to the entirety of the overdraft balance (where charges are applicable).  'Tiered' Where different charges/rates are applied dependent on overdraft maximum and minimum balance amount tiers defined by the lending financial organisation 'Banded' Where different charges/rates are applied dependent on overdraft maximum and minimum balance amount bands defined by a government organisation.")
    public TierBandMethodEnum getTierBandMethod() {
        return this.tierBandMethod;
    }

    public void setTierBandMethod(TierBandMethodEnum tierBandMethod) {
        this.tierBandMethod = tierBandMethod;
    }

    public Overdraft1OverdraftTierBandSet overdraftType(OverdraftTypeEnum overdraftType) {
        this.overdraftType = overdraftType;
        return this;
    }

    @ApiModelProperty(value="An overdraft can either be 'committed' which means that the facility cannot be withdrawn without reasonable notification before it's agreed end date, or 'on demand' which means that the financial institution can demand repayment at any point in time.")
    public OverdraftTypeEnum getOverdraftType() {
        return this.overdraftType;
    }

    public void setOverdraftType(OverdraftTypeEnum overdraftType) {
        this.overdraftType = overdraftType;
    }

    public Overdraft1OverdraftTierBandSet identification(String identification) {
        this.identification = identification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique and unambiguous identification of a  Tier Band for a overdraft product.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public Overdraft1OverdraftTierBandSet authorisedIndicator(Boolean authorisedIndicator) {
        this.authorisedIndicator = authorisedIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates if the Overdraft is authorised (Y) or unauthorised (N)")
    public Boolean isAuthorisedIndicator() {
        return this.authorisedIndicator;
    }

    public void setAuthorisedIndicator(Boolean authorisedIndicator) {
        this.authorisedIndicator = authorisedIndicator;
    }

    public Overdraft1OverdraftTierBandSet bufferAmount(String bufferAmount) {
        this.bufferAmount = bufferAmount;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="When a customer exceeds their credit limit, a financial institution will not charge the customer unauthorised overdraft charges if they do not exceed by more than the buffer amount. Note: Authorised overdraft charges may still apply.")
    public String getBufferAmount() {
        return this.bufferAmount;
    }

    public void setBufferAmount(String bufferAmount) {
        this.bufferAmount = bufferAmount;
    }

    public Overdraft1OverdraftTierBandSet notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public Overdraft1OverdraftTierBandSet addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the overdraft Tier Band Set details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public Overdraft1OverdraftTierBandSet overdraftTierBand(List<Overdraft1OverdraftTierBand> overdraftTierBand) {
        this.overdraftTierBand = overdraftTierBand;
        return this;
    }

    public Overdraft1OverdraftTierBandSet addOverdraftTierBandItem(Overdraft1OverdraftTierBand overdraftTierBandItem) {
        this.overdraftTierBand.add(overdraftTierBandItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=1)
    @ApiModelProperty(required=true, value="Provides overdraft details for a specific tier or band")
    public List<Overdraft1OverdraftTierBand> getOverdraftTierBand() {
        return this.overdraftTierBand;
    }

    public void setOverdraftTierBand(List<Overdraft1OverdraftTierBand> overdraftTierBand) {
        this.overdraftTierBand = overdraftTierBand;
    }

    public Overdraft1OverdraftTierBandSet overdraftFeesCharges(List<Overdraft1OverdraftFeesCharges1> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
        return this;
    }

    public Overdraft1OverdraftTierBandSet addOverdraftFeesChargesItem(Overdraft1OverdraftFeesCharges1 overdraftFeesChargesItem) {
        if (this.overdraftFeesCharges == null) {
            this.overdraftFeesCharges = new ArrayList<Overdraft1OverdraftFeesCharges1>();
        }
        this.overdraftFeesCharges.add(overdraftFeesChargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="Overdraft fees and charges details")
    public List<Overdraft1OverdraftFeesCharges1> getOverdraftFeesCharges() {
        return this.overdraftFeesCharges;
    }

    public void setOverdraftFeesCharges(List<Overdraft1OverdraftFeesCharges1> overdraftFeesCharges) {
        this.overdraftFeesCharges = overdraftFeesCharges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Overdraft1OverdraftTierBandSet overdraft1OverdraftTierBandSet = (Overdraft1OverdraftTierBandSet)o;
        return Objects.equals((Object)this.tierBandMethod, (Object)overdraft1OverdraftTierBandSet.tierBandMethod) && Objects.equals((Object)this.overdraftType, (Object)overdraft1OverdraftTierBandSet.overdraftType) && Objects.equals(this.identification, overdraft1OverdraftTierBandSet.identification) && Objects.equals(this.authorisedIndicator, overdraft1OverdraftTierBandSet.authorisedIndicator) && Objects.equals(this.bufferAmount, overdraft1OverdraftTierBandSet.bufferAmount) && Objects.equals(this.notes, overdraft1OverdraftTierBandSet.notes) && Objects.equals(this.overdraftTierBand, overdraft1OverdraftTierBandSet.overdraftTierBand) && Objects.equals(this.overdraftFeesCharges, overdraft1OverdraftTierBandSet.overdraftFeesCharges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tierBandMethod, this.overdraftType, this.identification, this.authorisedIndicator, this.bufferAmount, this.notes, this.overdraftTierBand, this.overdraftFeesCharges});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Overdraft1OverdraftTierBandSet {\n");
        sb.append("    tierBandMethod: ").append(this.toIndentedString((Object)this.tierBandMethod)).append("\n");
        sb.append("    overdraftType: ").append(this.toIndentedString((Object)this.overdraftType)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    authorisedIndicator: ").append(this.toIndentedString(this.authorisedIndicator)).append("\n");
        sb.append("    bufferAmount: ").append(this.toIndentedString(this.bufferAmount)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    overdraftTierBand: ").append(this.toIndentedString(this.overdraftTierBand)).append("\n");
        sb.append("    overdraftFeesCharges: ").append(this.toIndentedString(this.overdraftFeesCharges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OverdraftTypeEnum {
        COMMITTED("Committed"),
        ONDEMAND("OnDemand"),
        OTHER("Other");

        private String value;

        private OverdraftTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OverdraftTypeEnum fromValue(String text) {
            for (OverdraftTypeEnum b : OverdraftTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum TierBandMethodEnum {
        TIERED("Tiered"),
        WHOLE("Whole"),
        BANDED("Banded");

        private String value;

        private TierBandMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TierBandMethodEnum fromValue(String text) {
            for (TierBandMethodEnum b : TierBandMethodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

