/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ProductDetails {
    @JsonProperty(value="Segment")
    private List<SegmentEnum> segment = null;
    @JsonProperty(value="FeeFreeLength")
    private Float feeFreeLength = null;
    @JsonProperty(value="FeeFreeLengthPeriod")
    private FeeFreeLengthPeriodEnum feeFreeLengthPeriod = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;

    public ProductDetails segment(List<SegmentEnum> segment) {
        this.segment = segment;
        return this;
    }

    public ProductDetails addSegmentItem(SegmentEnum segmentItem) {
        if (this.segment == null) {
            this.segment = new ArrayList<SegmentEnum>();
        }
        this.segment.add(segmentItem);
        return this;
    }

    @ApiModelProperty(value="Market segmentation is a marketing term referring to the aggregating of prospective buyers into groups, or segments, that have common needs and respond similarly to a marketing action. Market segmentation enables companies to target different categories of consumers who perceive the full value of certain products and services differently from one another.  Read more: Market Segmentation http://www.investopedia.com/terms/m/marketsegmentation.asp#ixzz4gfEEalTd  With respect to BCA products, they are segmented in relation to different markets that they wish to focus on. ")
    public List<SegmentEnum> getSegment() {
        return this.segment;
    }

    public void setSegment(List<SegmentEnum> segment) {
        this.segment = segment;
    }

    public ProductDetails feeFreeLength(Float feeFreeLength) {
        this.feeFreeLength = feeFreeLength;
        return this;
    }

    @ApiModelProperty(value="The length/duration of the fee free period")
    public Float getFeeFreeLength() {
        return this.feeFreeLength;
    }

    public void setFeeFreeLength(Float feeFreeLength) {
        this.feeFreeLength = feeFreeLength;
    }

    public ProductDetails feeFreeLengthPeriod(FeeFreeLengthPeriodEnum feeFreeLengthPeriod) {
        this.feeFreeLengthPeriod = feeFreeLengthPeriod;
        return this;
    }

    @ApiModelProperty(value="The unit of period (days, weeks, months etc.) of the promotional length")
    public FeeFreeLengthPeriodEnum getFeeFreeLengthPeriod() {
        return this.feeFreeLengthPeriod;
    }

    public void setFeeFreeLengthPeriod(FeeFreeLengthPeriodEnum feeFreeLengthPeriod) {
        this.feeFreeLengthPeriod = feeFreeLengthPeriod;
    }

    public ProductDetails notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public ProductDetails addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Core product details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductDetails productDetails = (ProductDetails)o;
        return Objects.equals(this.segment, productDetails.segment) && Objects.equals(this.feeFreeLength, productDetails.feeFreeLength) && Objects.equals((Object)this.feeFreeLengthPeriod, (Object)productDetails.feeFreeLengthPeriod) && Objects.equals(this.notes, productDetails.notes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.segment, this.feeFreeLength, this.feeFreeLengthPeriod, this.notes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductDetails {\n");
        sb.append("    segment: ").append(this.toIndentedString(this.segment)).append("\n");
        sb.append("    feeFreeLength: ").append(this.toIndentedString(this.feeFreeLength)).append("\n");
        sb.append("    feeFreeLengthPeriod: ").append(this.toIndentedString((Object)this.feeFreeLengthPeriod)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FeeFreeLengthPeriodEnum {
        DAY("Day"),
        HALF_YEAR("Half Year"),
        MONTH("Month"),
        QUARTER("Quarter"),
        WEEK("Week"),
        YEAR("Year");

        private String value;

        private FeeFreeLengthPeriodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FeeFreeLengthPeriodEnum fromValue(String text) {
            for (FeeFreeLengthPeriodEnum b : FeeFreeLengthPeriodEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum SegmentEnum {
        CLIENTACCOUNT("ClientAccount"),
        STANDARD("Standard"),
        NONCOMMERCIALCHAITIESCLBSOC("NonCommercialChaitiesClbSoc"),
        NONCOMMERCIALPUBLICAUTHGOVT("NonCommercialPublicAuthGovt"),
        RELIGIOUS("Religious"),
        SECTORSPECIFIC("SectorSpecific"),
        STARTUP("Startup"),
        SWITCHER("Switcher");

        private String value;

        private SegmentEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SegmentEnum fromValue(String text) {
            for (SegmentEnum b : SegmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

