/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.Pattern;

public class ProductDetails1 {
    @JsonProperty(value="Segment")
    private List<SegmentEnum> segment = null;
    @JsonProperty(value="MonthlyMaximumCharge")
    private String monthlyMaximumCharge = null;
    @JsonProperty(value="Notes")
    private List<String> notes = null;

    public ProductDetails1 segment(List<SegmentEnum> segment) {
        this.segment = segment;
        return this;
    }

    public ProductDetails1 addSegmentItem(SegmentEnum segmentItem) {
        if (this.segment == null) {
            this.segment = new ArrayList<SegmentEnum>();
        }
        this.segment.add(segmentItem);
        return this;
    }

    @ApiModelProperty(value="Market segmentation is a marketing term referring to the aggregating of prospective buyers into groups, or segments, that have common needs and respond similarly to a marketing action. Market segmentation enables companies to target different categories of consumers who perceive the full value of certain products and services differently from one another.  Read more: Market Segmentation http://www.investopedia.com/terms/m/marketsegmentation.asp#ixzz4gfEEalTd  With respect to PCA products, they are segmented in relation to different markets that they wish to focus on. ")
    public List<SegmentEnum> getSegment() {
        return this.segment;
    }

    public void setSegment(List<SegmentEnum> segment) {
        this.segment = segment;
    }

    public ProductDetails1 monthlyMaximumCharge(String monthlyMaximumCharge) {
        this.monthlyMaximumCharge = monthlyMaximumCharge;
        return this;
    }

    @Pattern(regexp="^(-?\\d{1,14}){1}(\\.\\d{1,4}){0,1}$")
    @ApiModelProperty(value="The maximum relevant charges that could accrue as defined fully in Part 7 of the CMA order")
    public String getMonthlyMaximumCharge() {
        return this.monthlyMaximumCharge;
    }

    public void setMonthlyMaximumCharge(String monthlyMaximumCharge) {
        this.monthlyMaximumCharge = monthlyMaximumCharge;
    }

    public ProductDetails1 notes(List<String> notes) {
        this.notes = notes;
        return this;
    }

    public ProductDetails1 addNotesItem(String notesItem) {
        if (this.notes == null) {
            this.notes = new ArrayList<String>();
        }
        this.notes.add(notesItem);
        return this;
    }

    @ApiModelProperty(value="Optional additional notes to supplement the Core product details")
    public List<String> getNotes() {
        return this.notes;
    }

    public void setNotes(List<String> notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductDetails1 productDetails1 = (ProductDetails1)o;
        return Objects.equals(this.segment, productDetails1.segment) && Objects.equals(this.monthlyMaximumCharge, productDetails1.monthlyMaximumCharge) && Objects.equals(this.notes, productDetails1.notes);
    }

    public int hashCode() {
        return Objects.hash(this.segment, this.monthlyMaximumCharge, this.notes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductDetails1 {\n");
        sb.append("    segment: ").append(this.toIndentedString(this.segment)).append("\n");
        sb.append("    monthlyMaximumCharge: ").append(this.toIndentedString(this.monthlyMaximumCharge)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SegmentEnum {
        BASIC("Basic"),
        BENEFITANDREWARD("BenefitAndReward"),
        CREDITINTEREST("CreditInterest"),
        CASHBACK("Cashback"),
        GENERAL("General"),
        GRADUATE("Graduate"),
        OTHER("Other"),
        OVERDRAFT("Overdraft"),
        PACKAGED("Packaged"),
        PREMIUM("Premium"),
        REWARD("Reward"),
        STUDENT("Student"),
        YOUNGADULT("YoungAdult"),
        YOUTH("Youth");

        private String value;

        private SegmentEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SegmentEnum fromValue(String text) {
            for (SegmentEnum b : SegmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

