/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.discovery;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import uk.org.openbanking.datamodel.discovery.OBDiscoveryAPI;
import uk.org.openbanking.datamodel.discovery.OBDiscoveryAPILinks;

@ApiModel(description="Provides the endpoints details for payments and accounts API")
public class OBDiscovery {
    @JsonProperty(value="FinancialId")
    private String financialId;
    @JsonProperty(value="PaymentInitiationAPI")
    private List<OBDiscoveryAPI<OBDiscoveryAPILinks>> paymentInitiationAPIs;
    @JsonProperty(value="AccountAndTransactionAPI")
    private List<OBDiscoveryAPI<OBDiscoveryAPILinks>> accountAndTransactionAPIs;
    @JsonProperty(value="FundsConfirmationAPI")
    private List<OBDiscoveryAPI<OBDiscoveryAPILinks>> fundsConfirmationAPIs;
    @JsonProperty(value="EventNotificationAPI")
    private List<OBDiscoveryAPI<OBDiscoveryAPILinks>> eventNotificationAPIs;

    public String getFinancialId() {
        return this.financialId;
    }

    public void setFinancialId(String financialId) {
        this.financialId = financialId;
    }

    public OBDiscovery paymentInitiationAPI(List<OBDiscoveryAPI<OBDiscoveryAPILinks>> paymentInitiationAPIs) {
        this.paymentInitiationAPIs = paymentInitiationAPIs;
        return this;
    }

    public OBDiscovery addPaymentInitiationAPI(OBDiscoveryAPI<OBDiscoveryAPILinks> paymentInitiationAPI) {
        if (this.paymentInitiationAPIs == null) {
            this.paymentInitiationAPIs = new ArrayList<OBDiscoveryAPI<OBDiscoveryAPILinks>>();
        }
        this.paymentInitiationAPIs.add(paymentInitiationAPI);
        return this;
    }

    public List<OBDiscoveryAPI<OBDiscoveryAPILinks>> getPaymentInitiationAPIs() {
        return this.paymentInitiationAPIs;
    }

    public void setPaymentInitiationAPIs(List<OBDiscoveryAPI<OBDiscoveryAPILinks>> paymentInitiationAPIs) {
        this.paymentInitiationAPIs = paymentInitiationAPIs;
    }

    public Optional<OBDiscoveryAPI<OBDiscoveryAPILinks>> getPaymentInitiationAPI(String version) {
        return this.paymentInitiationAPIs.stream().filter(apis -> apis.getVersion().equals(version)).findFirst();
    }

    public OBDiscovery accountAndTransactionAPIs(List<OBDiscoveryAPI<OBDiscoveryAPILinks>> accountAndTransactionAPIs) {
        this.accountAndTransactionAPIs = accountAndTransactionAPIs;
        return this;
    }

    public OBDiscovery addAccountAndTransactionAPI(OBDiscoveryAPI<OBDiscoveryAPILinks> accountAndTransactionAPI) {
        if (this.accountAndTransactionAPIs == null) {
            this.accountAndTransactionAPIs = new ArrayList<OBDiscoveryAPI<OBDiscoveryAPILinks>>();
        }
        this.accountAndTransactionAPIs.add(accountAndTransactionAPI);
        return this;
    }

    public List<OBDiscoveryAPI<OBDiscoveryAPILinks>> getAccountAndTransactionAPIs() {
        return this.accountAndTransactionAPIs;
    }

    public void setAccountAndTransactionAPIs(List<OBDiscoveryAPI<OBDiscoveryAPILinks>> accountAndTransactionAPIs) {
        this.accountAndTransactionAPIs = accountAndTransactionAPIs;
    }

    public Optional<OBDiscoveryAPI<OBDiscoveryAPILinks>> getAccountAndTransactionAPI(String version) {
        return this.accountAndTransactionAPIs.stream().filter(apis -> apis.getVersion().equals(version)).findFirst();
    }

    public OBDiscovery fundsConfirmationAPI(List<OBDiscoveryAPI<OBDiscoveryAPILinks>> fundsConfirmationAPIs) {
        this.fundsConfirmationAPIs = fundsConfirmationAPIs;
        return this;
    }

    public OBDiscovery addFundsConfirmationAPI(OBDiscoveryAPI<OBDiscoveryAPILinks> fundsConfirmationAPI) {
        if (this.fundsConfirmationAPIs == null) {
            this.fundsConfirmationAPIs = new ArrayList<OBDiscoveryAPI<OBDiscoveryAPILinks>>();
        }
        this.fundsConfirmationAPIs.add(fundsConfirmationAPI);
        return this;
    }

    public List<OBDiscoveryAPI<OBDiscoveryAPILinks>> getFundsConfirmationAPIs() {
        return this.fundsConfirmationAPIs;
    }

    public void setFundsConfirmationAPIs(List<OBDiscoveryAPI<OBDiscoveryAPILinks>> fundsConfirmationAPIs) {
        this.fundsConfirmationAPIs = fundsConfirmationAPIs;
    }

    public Optional<OBDiscoveryAPI<OBDiscoveryAPILinks>> getFundsConfirmationAPIs(String version) {
        return this.fundsConfirmationAPIs.stream().filter(apis -> apis.getVersion().equals(version)).findFirst();
    }

    public OBDiscovery eventNotificationAPI(List<OBDiscoveryAPI<OBDiscoveryAPILinks>> eventNotificationAPIs) {
        this.eventNotificationAPIs = eventNotificationAPIs;
        return this;
    }

    public OBDiscovery addEventNotificationAPI(OBDiscoveryAPI<OBDiscoveryAPILinks> eventNotificationAPI) {
        if (this.eventNotificationAPIs == null) {
            this.eventNotificationAPIs = new ArrayList<OBDiscoveryAPI<OBDiscoveryAPILinks>>();
        }
        this.eventNotificationAPIs.add(eventNotificationAPI);
        return this;
    }

    public List<OBDiscoveryAPI<OBDiscoveryAPILinks>> getEventNotificationAPIs() {
        return this.eventNotificationAPIs;
    }

    public void setEventNotificationAPIs(List<OBDiscoveryAPI<OBDiscoveryAPILinks>> eventNotificationAPIs) {
        this.eventNotificationAPIs = eventNotificationAPIs;
    }

    public Optional<OBDiscoveryAPI<OBDiscoveryAPILinks>> getEventNotificationAPIs(String version) {
        return this.eventNotificationAPIs.stream().filter(apis -> apis.getVersion().equals(version)).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBDiscovery that = (OBDiscovery)o;
        return Objects.equals(this.paymentInitiationAPIs, that.paymentInitiationAPIs) && Objects.equals(this.accountAndTransactionAPIs, that.accountAndTransactionAPIs) && Objects.equals(this.fundsConfirmationAPIs, that.fundsConfirmationAPIs) && Objects.equals(this.eventNotificationAPIs, that.eventNotificationAPIs);
    }

    public int hashCode() {
        return Objects.hash(this.financialId, this.paymentInitiationAPIs, this.accountAndTransactionAPIs, this.fundsConfirmationAPIs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBDiscovery {\n");
        sb.append("    financialId: ").append(this.toIndentedString(this.financialId)).append("\n");
        sb.append("    paymentInitiationAPIs: ").append(this.toIndentedString(this.paymentInitiationAPIs)).append("\n");
        sb.append("    accountAndTransactionAPIs: ").append(this.toIndentedString(this.accountAndTransactionAPIs)).append("\n");
        sb.append("    fundsConfirmationAPIs: ").append(this.toIndentedString(this.fundsConfirmationAPIs)).append("\n");
        sb.append("    eventNotificationAPIs: ").append(this.toIndentedString(this.eventNotificationAPIs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

