/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="Provides the details to identify the beneficiary account.")
public class OBCashAccountCreditor3 {
    @JsonProperty(value="SchemeName")
    private String schemeName = null;
    @JsonProperty(value="Identification")
    private String identification = null;
    @JsonProperty(value="Name")
    private String name = null;
    @JsonProperty(value="SecondaryIdentification")
    private String secondaryIdentification = null;

    public OBCashAccountCreditor3 schemeName(String schemeName) {
        this.schemeName = schemeName;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="")
    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public OBCashAccountCreditor3 identification(String identification) {
        this.identification = identification;
        return this;
    }

    @NotNull
    @Size(min=1, max=256)
    @ApiModelProperty(required=true, value="Identification assigned by an institution to identify an account. This identification is known by the account owner.")
    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OBCashAccountCreditor3 name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Size(min=1, max=70)
    @ApiModelProperty(required=true, value="Name of the account, as assigned by the account servicing institution. Usage: The account name is the name or names of the account owner(s) represented at an account level. The account name is not the product name or the nickname of the account. OB: ASPSPs may carry out name validation for Confirmation of Payee, but it is not mandatory.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OBCashAccountCreditor3 secondaryIdentification(String secondaryIdentification) {
        this.secondaryIdentification = secondaryIdentification;
        return this;
    }

    @Size(min=1, max=34)
    @ApiModelProperty(value="This is secondary identification of the account, as assigned by the account servicing institution.  This can be used by building societies to additionally identify accounts with a roll number (in addition to a sort code and account number combination).")
    public String getSecondaryIdentification() {
        return this.secondaryIdentification;
    }

    public void setSecondaryIdentification(String secondaryIdentification) {
        this.secondaryIdentification = secondaryIdentification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBCashAccountCreditor3 obCashAccountCreditor3 = (OBCashAccountCreditor3)o;
        return Objects.equals(this.schemeName, obCashAccountCreditor3.schemeName) && Objects.equals(this.identification, obCashAccountCreditor3.identification) && Objects.equals(this.name, obCashAccountCreditor3.name) && Objects.equals(this.secondaryIdentification, obCashAccountCreditor3.secondaryIdentification);
    }

    public int hashCode() {
        return Objects.hash(this.schemeName, this.identification, this.name, this.secondaryIdentification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBCashAccountCreditor3 {\n");
        sb.append("    schemeName: ").append(this.toIndentedString(this.schemeName)).append("\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    secondaryIdentification: ").append(this.toIndentedString(this.secondaryIdentification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

