/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBExchangeRateType2Code;

@ApiModel(description="Further detailed information on the exchange rate that has been used in the payment transaction.")
@Validated
public class OBExchangeRate2 {
    @JsonProperty(value="UnitCurrency")
    private String unitCurrency = null;
    @JsonProperty(value="ExchangeRate")
    private BigDecimal exchangeRate = null;
    @JsonProperty(value="RateType")
    private OBExchangeRateType2Code rateType = null;
    @JsonProperty(value="ContractIdentification")
    private String contractIdentification = null;
    @JsonProperty(value="ExpirationDateTime")
    private DateTime expirationDateTime = null;

    public OBExchangeRate2 unitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
        return this;
    }

    @ApiModelProperty(required=true, value="Currency in which the rate of exchange is expressed in a currency exchange. In the example 1GBP = xxxCUR, the unit currency is GBP.")
    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getUnitCurrency() {
        return this.unitCurrency;
    }

    public void setUnitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
    }

    public OBExchangeRate2 exchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
        return this;
    }

    @ApiModelProperty(required=true, value="The factor used for conversion of an amount from one currency to another. This reflects the price at which one currency was bought with another currency.")
    @NotNull
    @Valid
    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public OBExchangeRate2 rateType(OBExchangeRateType2Code rateType) {
        this.rateType = rateType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExchangeRateType2Code getRateType() {
        return this.rateType;
    }

    public void setRateType(OBExchangeRateType2Code rateType) {
        this.rateType = rateType;
    }

    public OBExchangeRate2 contractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
        return this;
    }

    @ApiModelProperty(value="Unique and unambiguous reference to the foreign exchange contract agreed between the initiating party/creditor and the debtor agent.")
    @Size(min=1, max=256)
    public String getContractIdentification() {
        return this.contractIdentification;
    }

    public void setContractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
    }

    public OBExchangeRate2 expirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified date and time the exchange rate agreement will expire. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpirationDateTime() {
        return this.expirationDateTime;
    }

    public void setExpirationDateTime(DateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBExchangeRate2 obExchangeRate2 = (OBExchangeRate2)o;
        return Objects.equals(this.unitCurrency, obExchangeRate2.unitCurrency) && Objects.equals(this.exchangeRate, obExchangeRate2.exchangeRate) && Objects.equals((Object)this.rateType, (Object)obExchangeRate2.rateType) && Objects.equals(this.contractIdentification, obExchangeRate2.contractIdentification) && Objects.equals(this.expirationDateTime, obExchangeRate2.expirationDateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unitCurrency, this.exchangeRate, this.rateType, this.contractIdentification, this.expirationDateTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBExchangeRate2 {\n");
        sb.append("    unitCurrency: ").append(this.toIndentedString(this.unitCurrency)).append("\n");
        sb.append("    exchangeRate: ").append(this.toIndentedString(this.exchangeRate)).append("\n");
        sb.append("    rateType: ").append(this.toIndentedString((Object)this.rateType)).append("\n");
        sb.append("    contractIdentification: ").append(this.toIndentedString(this.contractIdentification)).append("\n");
        sb.append("    expirationDateTime: ").append(this.toIndentedString(this.expirationDateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

