/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification2;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.datamodel.payment.OBCashAccountCreditor1;
import uk.org.openbanking.datamodel.payment.OBCashAccountDebtor1;
import uk.org.openbanking.datamodel.payment.OBRemittanceInformation1;

@ApiModel(description="")
public class OBInitiation1 {
    @JsonProperty(value="InstructionIdentification")
    private String instructionIdentification = null;
    @JsonProperty(value="EndToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="InstructedAmount")
    private OBActiveOrHistoricCurrencyAndAmount instructedAmount = null;
    @JsonProperty(value="DebtorAgent")
    private OBBranchAndFinancialInstitutionIdentification2 debtorAgent = null;
    @JsonProperty(value="DebtorAccount")
    private OBCashAccountDebtor1 debtorAccount = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification2 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccountCreditor1 creditorAccount = null;
    @JsonProperty(value="RemittanceInformation")
    private OBRemittanceInformation1 remittanceInformation = null;

    public OBInitiation1 instructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification as assigned by an instructing party for an instructed party to unambiguously identify the instruction. Usage: the  instruction identification is a point to point reference that can be used between the instructing party and the instructed party to refer to the individual instruction. It can be included in several messages related to the instruction.")
    @NotNull
    @Size(min=1, max=35)
    public String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public OBInitiation1 endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain. Usage: The end-to-end identification can be used for reconciliation or to link tasks relating to the transaction. It can be included in several messages related to the transaction. OB: The Faster Payments Scheme can only access 31 characters for the EndToEndIdentification field.")
    @NotNull
    @Size(min=1, max=35)
    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public OBInitiation1 instructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBInitiation1 debtorAgent(OBBranchAndFinancialInstitutionIdentification2 debtorAgent) {
        this.debtorAgent = debtorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification2 getDebtorAgent() {
        return this.debtorAgent;
    }

    public void setDebtorAgent(OBBranchAndFinancialInstitutionIdentification2 debtorAgent) {
        this.debtorAgent = debtorAgent;
    }

    public OBInitiation1 debtorAccount(OBCashAccountDebtor1 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccountDebtor1 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBCashAccountDebtor1 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBInitiation1 creditorAgent(OBBranchAndFinancialInstitutionIdentification2 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification2 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification2 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBInitiation1 creditorAccount(OBCashAccountCreditor1 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccountCreditor1 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccountCreditor1 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBInitiation1 remittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBRemittanceInformation1 getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBInitiation1 initiation = (OBInitiation1)o;
        return Objects.equals(this.instructionIdentification, initiation.instructionIdentification) && Objects.equals(this.endToEndIdentification, initiation.endToEndIdentification) && Objects.equals(this.instructedAmount, initiation.instructedAmount) && Objects.equals(this.debtorAgent, initiation.debtorAgent) && Objects.equals(this.debtorAccount, initiation.debtorAccount) && Objects.equals(this.creditorAgent, initiation.creditorAgent) && Objects.equals(this.creditorAccount, initiation.creditorAccount) && Objects.equals(this.remittanceInformation, initiation.remittanceInformation);
    }

    public int hashCode() {
        return Objects.hash(this.instructionIdentification, this.endToEndIdentification, this.instructedAmount, this.debtorAgent, this.debtorAccount, this.creditorAgent, this.creditorAccount, this.remittanceInformation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentSetupInitiation {\n");
        sb.append("    instructionIdentification: ").append(this.toIndentedString(this.instructionIdentification)).append("\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    debtorAgent: ").append(this.toIndentedString(this.debtorAgent)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

