/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.account.OBCashAccount3;
import uk.org.openbanking.datamodel.payment.OBActiveOrHistoricCurrencyAndAmount;
import uk.org.openbanking.datamodel.payment.OBBranchAndFinancialInstitutionIdentification3;
import uk.org.openbanking.datamodel.payment.OBChargeBearerType1Code;
import uk.org.openbanking.datamodel.payment.OBExchangeRate1;
import uk.org.openbanking.datamodel.payment.OBPartyIdentification43;
import uk.org.openbanking.datamodel.payment.OBPriority2Code;
import uk.org.openbanking.datamodel.payment.OBRemittanceInformation1;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds from the debtor account to a creditor for a single international payment.")
@Validated
public class OBInternational1 {
    @JsonProperty(value="InstructionIdentification")
    private String instructionIdentification = null;
    @JsonProperty(value="EndToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="LocalInstrument")
    private String localInstrument = null;
    @JsonProperty(value="InstructionPriority")
    private OBPriority2Code instructionPriority = null;
    @JsonProperty(value="Purpose")
    private String purpose = null;
    @JsonProperty(value="ChargeBearer")
    private OBChargeBearerType1Code chargeBearer = null;
    @JsonProperty(value="CurrencyOfTransfer")
    private String currencyOfTransfer = null;
    @JsonProperty(value="InstructedAmount")
    private OBActiveOrHistoricCurrencyAndAmount instructedAmount = null;
    @JsonProperty(value="ExchangeRateInformation")
    private OBExchangeRate1 exchangeRateInformation = null;
    @JsonProperty(value="DebtorAccount")
    private OBCashAccount3 debtorAccount = null;
    @JsonProperty(value="Creditor")
    private OBPartyIdentification43 creditor = null;
    @JsonProperty(value="CreditorAgent")
    private OBBranchAndFinancialInstitutionIdentification3 creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBCashAccount3 creditorAccount = null;
    @JsonProperty(value="RemittanceInformation")
    private OBRemittanceInformation1 remittanceInformation = null;

    public OBInternational1 instructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification as assigned by an instructing party for an instructed party to unambiguously identify the instruction. Usage: the  instruction identification is a point to point reference that can be used between the instructing party and the instructed party to refer to the individual instruction. It can be included in several messages related to the instruction.")
    @NotNull
    @Size(min=1, max=35)
    public String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public OBInternational1 endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain. Usage: The end-to-end identification can be used for reconciliation or to link tasks relating to the transaction. It can be included in several messages related to the transaction. OB: The Faster Payments Scheme can only access 31 characters for the EndToEndIdentification field.")
    @NotNull
    @Size(min=1, max=35)
    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public OBInternational1 localInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
        return this;
    }

    @ApiModelProperty(value="User community specific instrument. Usage: This element is used to specify a local instrument, local clearing option and/or further qualify the service or service level.")
    @Size(min=1, max=35)
    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public OBInternational1 instructionPriority(OBPriority2Code instructionPriority) {
        this.instructionPriority = instructionPriority;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBPriority2Code getInstructionPriority() {
        return this.instructionPriority;
    }

    public void setInstructionPriority(OBPriority2Code instructionPriority) {
        this.instructionPriority = instructionPriority;
    }

    public OBInternational1 purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="Specifies the external purpose code in the format of character string with a maximum length of 35 characters. The list of valid codes is an external code list published separately. External code sets can be downloaded from www.iso20022.org.")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public OBInternational1 chargeBearer(OBChargeBearerType1Code chargeBearer) {
        this.chargeBearer = chargeBearer;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBChargeBearerType1Code getChargeBearer() {
        return this.chargeBearer;
    }

    public void setChargeBearer(OBChargeBearerType1Code chargeBearer) {
        this.chargeBearer = chargeBearer;
    }

    public OBInternational1 currencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the currency of the to be transferred amount, which is different from the currency of the debtor's account.")
    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    public String getCurrencyOfTransfer() {
        return this.currencyOfTransfer;
    }

    public void setCurrencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
    }

    public OBInternational1 instructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBActiveOrHistoricCurrencyAndAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBActiveOrHistoricCurrencyAndAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBInternational1 exchangeRateInformation(OBExchangeRate1 exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExchangeRate1 getExchangeRateInformation() {
        return this.exchangeRateInformation;
    }

    public void setExchangeRateInformation(OBExchangeRate1 exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
    }

    public OBInternational1 debtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBCashAccount3 getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBCashAccount3 debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBInternational1 creditor(OBPartyIdentification43 creditor) {
        this.creditor = creditor;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBPartyIdentification43 getCreditor() {
        return this.creditor;
    }

    public void setCreditor(OBPartyIdentification43 creditor) {
        this.creditor = creditor;
    }

    public OBInternational1 creditorAgent(OBBranchAndFinancialInstitutionIdentification3 creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBBranchAndFinancialInstitutionIdentification3 getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBBranchAndFinancialInstitutionIdentification3 creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBInternational1 creditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBCashAccount3 getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBCashAccount3 creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBInternational1 remittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBRemittanceInformation1 getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(OBRemittanceInformation1 remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBInternational1 obInternational1 = (OBInternational1)o;
        return Objects.equals(this.instructionIdentification, obInternational1.instructionIdentification) && Objects.equals(this.endToEndIdentification, obInternational1.endToEndIdentification) && Objects.equals(this.localInstrument, obInternational1.localInstrument) && Objects.equals((Object)this.instructionPriority, (Object)obInternational1.instructionPriority) && Objects.equals(this.purpose, obInternational1.purpose) && Objects.equals((Object)this.chargeBearer, (Object)obInternational1.chargeBearer) && Objects.equals(this.currencyOfTransfer, obInternational1.currencyOfTransfer) && Objects.equals(this.instructedAmount, obInternational1.instructedAmount) && Objects.equals(this.exchangeRateInformation, obInternational1.exchangeRateInformation) && Objects.equals(this.debtorAccount, obInternational1.debtorAccount) && Objects.equals(this.creditor, obInternational1.creditor) && Objects.equals(this.creditorAgent, obInternational1.creditorAgent) && Objects.equals(this.creditorAccount, obInternational1.creditorAccount) && Objects.equals(this.remittanceInformation, obInternational1.remittanceInformation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.instructionIdentification, this.endToEndIdentification, this.localInstrument, this.instructionPriority, this.purpose, this.chargeBearer, this.currencyOfTransfer, this.instructedAmount, this.exchangeRateInformation, this.debtorAccount, this.creditor, this.creditorAgent, this.creditorAccount, this.remittanceInformation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBInternational1 {\n");
        sb.append("    instructionIdentification: ").append(this.toIndentedString(this.instructionIdentification)).append("\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    localInstrument: ").append(this.toIndentedString(this.localInstrument)).append("\n");
        sb.append("    instructionPriority: ").append(this.toIndentedString((Object)this.instructionPriority)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    chargeBearer: ").append(this.toIndentedString((Object)this.chargeBearer)).append("\n");
        sb.append("    currencyOfTransfer: ").append(this.toIndentedString(this.currencyOfTransfer)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    exchangeRateInformation: ").append(this.toIndentedString(this.exchangeRateInformation)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditor: ").append(this.toIndentedString(this.creditor)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

