/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBInitiation1;
import uk.org.openbanking.datamodel.payment.OBTransactionIndividualStatus1Code;
import uk.org.openbanking.jackson.DateTimeDeserializer;
import uk.org.openbanking.jackson.DateTimeSerializer;

@ApiModel(description="Reflection of The Main Data Payload, with Created Resource ID, Status and Timestamp")
public class OBPaymentDataSetupResponse1 {
    @JsonProperty(value="PaymentId")
    private String paymentId = null;
    @JsonProperty(value="Status")
    private OBTransactionIndividualStatus1Code status = null;
    @JsonProperty(value="CreationDateTime")
    @JsonDeserialize(using=DateTimeDeserializer.class)
    @JsonSerialize(using=DateTimeSerializer.class)
    private DateTime creationDateTime = null;
    @JsonProperty(value="Initiation")
    private OBInitiation1 initiation = null;

    public OBPaymentDataSetupResponse1 paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the payment setup resource.")
    @NotNull
    @Size(min=1, max=128)
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public OBPaymentDataSetupResponse1 status(OBTransactionIndividualStatus1Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Specifies the status of the payment resource.")
    public OBTransactionIndividualStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBTransactionIndividualStatus1Code status) {
        this.status = status;
    }

    public OBPaymentDataSetupResponse1 creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource was created.  All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBPaymentDataSetupResponse1 initiation(OBInitiation1 initiation) {
        this.initiation = initiation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBInitiation1 getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBInitiation1 initiation) {
        this.initiation = initiation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBPaymentDataSetupResponse1 paymentSetupResponse = (OBPaymentDataSetupResponse1)o;
        return Objects.equals(this.paymentId, paymentSetupResponse.paymentId) && Objects.equals((Object)this.status, (Object)paymentSetupResponse.status) && Objects.equals(this.creationDateTime, paymentSetupResponse.creationDateTime) && Objects.equals(this.initiation, paymentSetupResponse.initiation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentId, this.status, this.creationDateTime, this.initiation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentSetupResponse {\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

