/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBAddressTypeCode;

@ApiModel(description="Information that locates and identifies a specific address, as defined by postal services.")
@Validated
public class OBPostalAddress6 {
    @JsonProperty(value="AddressType")
    private OBAddressTypeCode addressType = null;
    @JsonProperty(value="Department")
    private String department = null;
    @JsonProperty(value="SubDepartment")
    private String subDepartment = null;
    @JsonProperty(value="StreetName")
    private String streetName = null;
    @JsonProperty(value="BuildingNumber")
    private String buildingNumber = null;
    @JsonProperty(value="PostCode")
    private String postCode = null;
    @JsonProperty(value="TownName")
    private String townName = null;
    @JsonProperty(value="CountrySubDivision")
    private String countrySubDivision = null;
    @JsonProperty(value="Country")
    private String country = null;
    @JsonProperty(value="AddressLine")
    @Valid
    private List<String> addressLine = null;

    public OBPostalAddress6 addressType(OBAddressTypeCode addressType) {
        this.addressType = addressType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBAddressTypeCode getAddressType() {
        return this.addressType;
    }

    public void setAddressType(OBAddressTypeCode addressType) {
        this.addressType = addressType;
    }

    public OBPostalAddress6 department(String department) {
        this.department = department;
        return this;
    }

    @ApiModelProperty(value="Identification of a division of a large organisation or building.")
    @Size(min=1, max=70)
    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public OBPostalAddress6 subDepartment(String subDepartment) {
        this.subDepartment = subDepartment;
        return this;
    }

    @ApiModelProperty(value="Identification of a sub-division of a large organisation or building.")
    @Size(min=1, max=70)
    public String getSubDepartment() {
        return this.subDepartment;
    }

    public void setSubDepartment(String subDepartment) {
        this.subDepartment = subDepartment;
    }

    public OBPostalAddress6 streetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    @ApiModelProperty(value="Name of a street or thoroughfare.")
    @Size(min=1, max=70)
    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public OBPostalAddress6 buildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
        return this;
    }

    @ApiModelProperty(value="Number that identifies the position of a building on a street.")
    @Size(min=1, max=16)
    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public OBPostalAddress6 postCode(String postCode) {
        this.postCode = postCode;
        return this;
    }

    @ApiModelProperty(value="Identifier consisting of a group of letters and/or numbers that is added to a postal address to assist the sorting of mail.")
    @Size(min=1, max=16)
    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public OBPostalAddress6 townName(String townName) {
        this.townName = townName;
        return this;
    }

    @ApiModelProperty(value="Name of a built-up area, with defined boundaries, and a local government.")
    @Size(min=1, max=35)
    public String getTownName() {
        return this.townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public OBPostalAddress6 countrySubDivision(String countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
        return this;
    }

    @ApiModelProperty(value="Identifies a subdivision of a country such as state, region, county.")
    @Size(min=1, max=35)
    public String getCountrySubDivision() {
        return this.countrySubDivision;
    }

    public void setCountrySubDivision(String countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
    }

    public OBPostalAddress6 country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="Nation with its own government.")
    @Pattern(regexp="^[A-Z]{2,2}$")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public OBPostalAddress6 addressLine(List<String> addressLine) {
        this.addressLine = addressLine;
        return this;
    }

    public OBPostalAddress6 addAddressLineItem(String addressLineItem) {
        if (this.addressLine == null) {
            this.addressLine = new ArrayList<String>();
        }
        this.addressLine.add(addressLineItem);
        return this;
    }

    @ApiModelProperty(value="Information that locates and identifies a specific address, as defined by postal services, presented in free format text.")
    @Size(min=0, max=7)
    public List<String> getAddressLine() {
        return this.addressLine;
    }

    public void setAddressLine(List<String> addressLine) {
        this.addressLine = addressLine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBPostalAddress6 obPostalAddress6 = (OBPostalAddress6)o;
        return Objects.equals((Object)this.addressType, (Object)obPostalAddress6.addressType) && Objects.equals(this.department, obPostalAddress6.department) && Objects.equals(this.subDepartment, obPostalAddress6.subDepartment) && Objects.equals(this.streetName, obPostalAddress6.streetName) && Objects.equals(this.buildingNumber, obPostalAddress6.buildingNumber) && Objects.equals(this.postCode, obPostalAddress6.postCode) && Objects.equals(this.townName, obPostalAddress6.townName) && Objects.equals(this.countrySubDivision, obPostalAddress6.countrySubDivision) && Objects.equals(this.country, obPostalAddress6.country) && Objects.equals(this.addressLine, obPostalAddress6.addressLine);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressType, this.department, this.subDepartment, this.streetName, this.buildingNumber, this.postCode, this.townName, this.countrySubDivision, this.country, this.addressLine});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBPostalAddress6 {\n");
        sb.append("    addressType: ").append(this.toIndentedString((Object)this.addressType)).append("\n");
        sb.append("    department: ").append(this.toIndentedString(this.department)).append("\n");
        sb.append("    subDepartment: ").append(this.toIndentedString(this.subDepartment)).append("\n");
        sb.append("    streetName: ").append(this.toIndentedString(this.streetName)).append("\n");
        sb.append("    buildingNumber: ").append(this.toIndentedString(this.buildingNumber)).append("\n");
        sb.append("    postCode: ").append(this.toIndentedString(this.postCode)).append("\n");
        sb.append("    townName: ").append(this.toIndentedString(this.townName)).append("\n");
        sb.append("    countrySubDivision: ").append(this.toIndentedString(this.countrySubDivision)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    addressLine: ").append(this.toIndentedString(this.addressLine)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

