/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBExternalPaymentContext1Code;
import uk.org.openbanking.datamodel.payment.OBRisk1DeliveryAddress;

@ApiModel(description="The Risk section is sent by the initiating party to the ASPSP. It is used to specify additional details for risk scoring for Payments.")
@Validated
public class OBRisk1 {
    @JsonProperty(value="PaymentContextCode")
    private OBExternalPaymentContext1Code paymentContextCode = null;
    @JsonProperty(value="MerchantCategoryCode")
    private String merchantCategoryCode = null;
    @JsonProperty(value="MerchantCustomerIdentification")
    private String merchantCustomerIdentification = null;
    @JsonProperty(value="DeliveryAddress")
    private OBRisk1DeliveryAddress deliveryAddress = null;

    public OBRisk1 paymentContextCode(OBExternalPaymentContext1Code paymentContextCode) {
        this.paymentContextCode = paymentContextCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExternalPaymentContext1Code getPaymentContextCode() {
        return this.paymentContextCode;
    }

    public void setPaymentContextCode(OBExternalPaymentContext1Code paymentContextCode) {
        this.paymentContextCode = paymentContextCode;
    }

    public OBRisk1 merchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
        return this;
    }

    @ApiModelProperty(value="Category code conform to ISO 18245, related to the type of services or goods the merchant provides for the transaction.")
    @Size(min=3, max=4)
    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public OBRisk1 merchantCustomerIdentification(String merchantCustomerIdentification) {
        this.merchantCustomerIdentification = merchantCustomerIdentification;
        return this;
    }

    @ApiModelProperty(value="The unique customer identifier of the PSU with the merchant.")
    @Size(min=1, max=70)
    public String getMerchantCustomerIdentification() {
        return this.merchantCustomerIdentification;
    }

    public void setMerchantCustomerIdentification(String merchantCustomerIdentification) {
        this.merchantCustomerIdentification = merchantCustomerIdentification;
    }

    public OBRisk1 deliveryAddress(OBRisk1DeliveryAddress deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBRisk1DeliveryAddress getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(OBRisk1DeliveryAddress deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBRisk1 obRisk1 = (OBRisk1)o;
        return Objects.equals((Object)this.paymentContextCode, (Object)obRisk1.paymentContextCode) && Objects.equals(this.merchantCategoryCode, obRisk1.merchantCategoryCode) && Objects.equals(this.merchantCustomerIdentification, obRisk1.merchantCustomerIdentification) && Objects.equals(this.deliveryAddress, obRisk1.deliveryAddress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentContextCode, this.merchantCategoryCode, this.merchantCustomerIdentification, this.deliveryAddress});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBRisk1 {\n");
        sb.append("    paymentContextCode: ").append(this.toIndentedString((Object)this.paymentContextCode)).append("\n");
        sb.append("    merchantCategoryCode: ").append(this.toIndentedString(this.merchantCategoryCode)).append("\n");
        sb.append("    merchantCustomerIdentification: ").append(this.toIndentedString(this.merchantCustomerIdentification)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

