/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Information that locates and identifies a specific address, as defined by postal services or in free format text.")
@Validated
public class OBRisk1DeliveryAddress {
    @JsonProperty(value="AddressLine")
    @Valid
    private List<String> addressLine = null;
    @JsonProperty(value="StreetName")
    private String streetName = null;
    @JsonProperty(value="BuildingNumber")
    private String buildingNumber = null;
    @JsonProperty(value="PostCode")
    private String postCode = null;
    @JsonProperty(value="TownName")
    private String townName = null;
    @JsonProperty(value="CountrySubDivision")
    @Valid
    private List<String> countrySubDivision = null;
    @JsonProperty(value="Country")
    private String country = null;

    public OBRisk1DeliveryAddress addressLine(List<String> addressLine) {
        this.addressLine = addressLine;
        return this;
    }

    public OBRisk1DeliveryAddress addAddressLineItem(String addressLineItem) {
        if (this.addressLine == null) {
            this.addressLine = new ArrayList<String>();
        }
        this.addressLine.add(addressLineItem);
        return this;
    }

    @ApiModelProperty(value="Information that locates and identifies a specific address, as defined by postal services, that is presented in free format text.")
    @Size(min=0, max=2)
    public List<String> getAddressLine() {
        return this.addressLine;
    }

    public void setAddressLine(List<String> addressLine) {
        this.addressLine = addressLine;
    }

    public OBRisk1DeliveryAddress streetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    @ApiModelProperty(value="Name of a street or thoroughfare.")
    @Size(min=1, max=70)
    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public OBRisk1DeliveryAddress buildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
        return this;
    }

    @ApiModelProperty(value="Number that identifies the position of a building on a street.")
    @Size(min=1, max=16)
    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public OBRisk1DeliveryAddress postCode(String postCode) {
        this.postCode = postCode;
        return this;
    }

    @ApiModelProperty(value="Identifier consisting of a group of letters and/or numbers that is added to a postal address to assist the sorting of mail.")
    @Size(min=1, max=16)
    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public OBRisk1DeliveryAddress townName(String townName) {
        this.townName = townName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of a built-up area, with defined boundaries, and a local government.")
    @NotNull
    @Size(min=1, max=35)
    public String getTownName() {
        return this.townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public OBRisk1DeliveryAddress countrySubDivision(List<String> countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
        return this;
    }

    public OBRisk1DeliveryAddress addCountrySubDivisionItem(String countrySubDivisionItem) {
        if (this.countrySubDivision == null) {
            this.countrySubDivision = new ArrayList<String>();
        }
        this.countrySubDivision.add(countrySubDivisionItem);
        return this;
    }

    @ApiModelProperty(value="Identifies a subdivision of a country, for instance state, region, county.")
    @Size(min=0, max=2)
    public List<String> getCountrySubDivision() {
        return this.countrySubDivision;
    }

    public void setCountrySubDivision(List<String> countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
    }

    public OBRisk1DeliveryAddress country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="Nation with its own government, occupying a particular territory.")
    @NotNull
    @Pattern(regexp="^[A-Z]{2,2}$")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBRisk1DeliveryAddress obRisk1DeliveryAddress = (OBRisk1DeliveryAddress)o;
        return Objects.equals(this.addressLine, obRisk1DeliveryAddress.addressLine) && Objects.equals(this.streetName, obRisk1DeliveryAddress.streetName) && Objects.equals(this.buildingNumber, obRisk1DeliveryAddress.buildingNumber) && Objects.equals(this.postCode, obRisk1DeliveryAddress.postCode) && Objects.equals(this.townName, obRisk1DeliveryAddress.townName) && Objects.equals(this.countrySubDivision, obRisk1DeliveryAddress.countrySubDivision) && Objects.equals(this.country, obRisk1DeliveryAddress.country);
    }

    public int hashCode() {
        return Objects.hash(this.addressLine, this.streetName, this.buildingNumber, this.postCode, this.townName, this.countrySubDivision, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBRisk1DeliveryAddress {\n");
        sb.append("    addressLine: ").append(this.toIndentedString(this.addressLine)).append("\n");
        sb.append("    streetName: ").append(this.toIndentedString(this.streetName)).append("\n");
        sb.append("    buildingNumber: ").append(this.toIndentedString(this.buildingNumber)).append("\n");
        sb.append("    postCode: ").append(this.toIndentedString(this.postCode)).append("\n");
        sb.append("    townName: ").append(this.toIndentedString(this.townName)).append("\n");
        sb.append("    countrySubDivision: ").append(this.toIndentedString(this.countrySubDivision)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

