/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBCharge1;
import uk.org.openbanking.datamodel.payment.OBDomesticScheduled2;
import uk.org.openbanking.datamodel.payment.OBExternalStatus1Code;
import uk.org.openbanking.datamodel.payment.OBMultiAuthorisation1;

@Validated
public class OBWriteDataDomesticScheduledResponse2 {
    @JsonProperty(value="DomesticScheduledPaymentId")
    private String domesticScheduledPaymentId = null;
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private OBExternalStatus1Code status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="ExpectedExecutionDateTime")
    private DateTime expectedExecutionDateTime = null;
    @JsonProperty(value="ExpectedSettlementDateTime")
    private DateTime expectedSettlementDateTime = null;
    @JsonProperty(value="Charges")
    @Valid
    private List<OBCharge1> charges = null;
    @JsonProperty(value="Initiation")
    private OBDomesticScheduled2 initiation = null;
    @JsonProperty(value="MultiAuthorisation")
    private OBMultiAuthorisation1 multiAuthorisation = null;

    public OBWriteDataDomesticScheduledResponse2 domesticScheduledPaymentId(String domesticScheduledPaymentId) {
        this.domesticScheduledPaymentId = domesticScheduledPaymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the domestic schedule payment resource.")
    @NotNull
    @Size(min=1, max=40)
    public String getDomesticScheduledPaymentId() {
        return this.domesticScheduledPaymentId;
    }

    public void setDomesticScheduledPaymentId(String domesticScheduledPaymentId) {
        this.domesticScheduledPaymentId = domesticScheduledPaymentId;
    }

    public OBWriteDataDomesticScheduledResponse2 consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the consent resource.")
    @NotNull
    @Size(min=1, max=128)
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBWriteDataDomesticScheduledResponse2 creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the message was created. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBWriteDataDomesticScheduledResponse2 status(OBExternalStatus1Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBExternalStatus1Code status) {
        this.status = status;
    }

    public OBWriteDataDomesticScheduledResponse2 statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource status was updated. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWriteDataDomesticScheduledResponse2 expectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
        return this;
    }

    @ApiModelProperty(value="Expected execution date and time for the payment resource. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpectedExecutionDateTime() {
        return this.expectedExecutionDateTime;
    }

    public void setExpectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
    }

    public OBWriteDataDomesticScheduledResponse2 expectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
        return this;
    }

    @ApiModelProperty(value="Expected settlement date and time for the payment resource. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpectedSettlementDateTime() {
        return this.expectedSettlementDateTime;
    }

    public void setExpectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
    }

    public OBWriteDataDomesticScheduledResponse2 charges(List<OBCharge1> charges) {
        this.charges = charges;
        return this;
    }

    public OBWriteDataDomesticScheduledResponse2 addChargesItem(OBCharge1 chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<OBCharge1>();
        }
        this.charges.add(chargesItem);
        return this;
    }

    @ApiModelProperty(value="Set of elements used to provide details of a charge for the payment initiation.")
    @Valid
    public List<OBCharge1> getCharges() {
        return this.charges;
    }

    public void setCharges(List<OBCharge1> charges) {
        this.charges = charges;
    }

    public OBWriteDataDomesticScheduledResponse2 initiation(OBDomesticScheduled2 initiation) {
        this.initiation = initiation;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBDomesticScheduled2 getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBDomesticScheduled2 initiation) {
        this.initiation = initiation;
    }

    public OBWriteDataDomesticScheduledResponse2 multiAuthorisation(OBMultiAuthorisation1 multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBMultiAuthorisation1 getMultiAuthorisation() {
        return this.multiAuthorisation;
    }

    public void setMultiAuthorisation(OBMultiAuthorisation1 multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDataDomesticScheduledResponse2 obWriteDataDomesticScheduledResponse2 = (OBWriteDataDomesticScheduledResponse2)o;
        return Objects.equals(this.domesticScheduledPaymentId, obWriteDataDomesticScheduledResponse2.domesticScheduledPaymentId) && Objects.equals(this.consentId, obWriteDataDomesticScheduledResponse2.consentId) && Objects.equals(this.creationDateTime, obWriteDataDomesticScheduledResponse2.creationDateTime) && Objects.equals((Object)this.status, (Object)obWriteDataDomesticScheduledResponse2.status) && Objects.equals(this.statusUpdateDateTime, obWriteDataDomesticScheduledResponse2.statusUpdateDateTime) && Objects.equals(this.expectedExecutionDateTime, obWriteDataDomesticScheduledResponse2.expectedExecutionDateTime) && Objects.equals(this.expectedSettlementDateTime, obWriteDataDomesticScheduledResponse2.expectedSettlementDateTime) && Objects.equals(this.charges, obWriteDataDomesticScheduledResponse2.charges) && Objects.equals(this.initiation, obWriteDataDomesticScheduledResponse2.initiation) && Objects.equals(this.multiAuthorisation, obWriteDataDomesticScheduledResponse2.multiAuthorisation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domesticScheduledPaymentId, this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.expectedExecutionDateTime, this.expectedSettlementDateTime, this.charges, this.initiation, this.multiAuthorisation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDataDomesticScheduledResponse2 {\n");
        sb.append("    domesticScheduledPaymentId: ").append(this.toIndentedString(this.domesticScheduledPaymentId)).append("\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    expectedExecutionDateTime: ").append(this.toIndentedString(this.expectedExecutionDateTime)).append("\n");
        sb.append("    expectedSettlementDateTime: ").append(this.toIndentedString(this.expectedSettlementDateTime)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("    multiAuthorisation: ").append(this.toIndentedString(this.multiAuthorisation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

