/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBAuthorisation1;
import uk.org.openbanking.datamodel.payment.OBCharge1;
import uk.org.openbanking.datamodel.payment.OBExchangeRate2;
import uk.org.openbanking.datamodel.payment.OBExternalConsentStatus1Code;
import uk.org.openbanking.datamodel.payment.OBInternational1;

@Validated
public class OBWriteDataInternationalConsentResponse1 {
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private OBExternalConsentStatus1Code status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="CutOffDateTime")
    private DateTime cutOffDateTime = null;
    @JsonProperty(value="ExpectedExecutionDateTime")
    private DateTime expectedExecutionDateTime = null;
    @JsonProperty(value="ExpectedSettlementDateTime")
    private DateTime expectedSettlementDateTime = null;
    @JsonProperty(value="Charges")
    @Valid
    private List<OBCharge1> charges = null;
    @JsonProperty(value="ExchangeRateInformation")
    private OBExchangeRate2 exchangeRateInformation = null;
    @JsonProperty(value="Initiation")
    private OBInternational1 initiation = null;
    @JsonProperty(value="Authorisation")
    private OBAuthorisation1 authorisation = null;

    public OBWriteDataInternationalConsentResponse1 consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the consent resource.")
    @NotNull
    @Size(min=1, max=128)
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBWriteDataInternationalConsentResponse1 creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource was created. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBWriteDataInternationalConsentResponse1 status(OBExternalConsentStatus1Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalConsentStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBExternalConsentStatus1Code status) {
        this.status = status;
    }

    public OBWriteDataInternationalConsentResponse1 statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource status was updated. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWriteDataInternationalConsentResponse1 cutOffDateTime(DateTime cutOffDateTime) {
        this.cutOffDateTime = cutOffDateTime;
        return this;
    }

    @ApiModelProperty(value="Specified cut-off date and time for the payment consent. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getCutOffDateTime() {
        return this.cutOffDateTime;
    }

    public void setCutOffDateTime(DateTime cutOffDateTime) {
        this.cutOffDateTime = cutOffDateTime;
    }

    public OBWriteDataInternationalConsentResponse1 expectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
        return this;
    }

    @ApiModelProperty(value="Expected execution date and time for the payment resource. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpectedExecutionDateTime() {
        return this.expectedExecutionDateTime;
    }

    public void setExpectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
    }

    public OBWriteDataInternationalConsentResponse1 expectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
        return this;
    }

    @ApiModelProperty(value="Expected settlement date and time for the payment resource. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @Valid
    public DateTime getExpectedSettlementDateTime() {
        return this.expectedSettlementDateTime;
    }

    public void setExpectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
    }

    public OBWriteDataInternationalConsentResponse1 charges(List<OBCharge1> charges) {
        this.charges = charges;
        return this;
    }

    public OBWriteDataInternationalConsentResponse1 addChargesItem(OBCharge1 chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<OBCharge1>();
        }
        this.charges.add(chargesItem);
        return this;
    }

    @ApiModelProperty(value="Set of elements used to provide details of a charge for the payment initiation.")
    @Valid
    public List<OBCharge1> getCharges() {
        return this.charges;
    }

    public void setCharges(List<OBCharge1> charges) {
        this.charges = charges;
    }

    public OBWriteDataInternationalConsentResponse1 exchangeRateInformation(OBExchangeRate2 exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBExchangeRate2 getExchangeRateInformation() {
        return this.exchangeRateInformation;
    }

    public void setExchangeRateInformation(OBExchangeRate2 exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
    }

    public OBWriteDataInternationalConsentResponse1 initiation(OBInternational1 initiation) {
        this.initiation = initiation;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBInternational1 getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBInternational1 initiation) {
        this.initiation = initiation;
    }

    public OBWriteDataInternationalConsentResponse1 authorisation(OBAuthorisation1 authorisation) {
        this.authorisation = authorisation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBAuthorisation1 getAuthorisation() {
        return this.authorisation;
    }

    public void setAuthorisation(OBAuthorisation1 authorisation) {
        this.authorisation = authorisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDataInternationalConsentResponse1 obWriteDataInternationalConsentResponse1 = (OBWriteDataInternationalConsentResponse1)o;
        return Objects.equals(this.consentId, obWriteDataInternationalConsentResponse1.consentId) && Objects.equals(this.creationDateTime, obWriteDataInternationalConsentResponse1.creationDateTime) && Objects.equals((Object)this.status, (Object)obWriteDataInternationalConsentResponse1.status) && Objects.equals(this.statusUpdateDateTime, obWriteDataInternationalConsentResponse1.statusUpdateDateTime) && Objects.equals(this.cutOffDateTime, obWriteDataInternationalConsentResponse1.cutOffDateTime) && Objects.equals(this.expectedExecutionDateTime, obWriteDataInternationalConsentResponse1.expectedExecutionDateTime) && Objects.equals(this.expectedSettlementDateTime, obWriteDataInternationalConsentResponse1.expectedSettlementDateTime) && Objects.equals(this.charges, obWriteDataInternationalConsentResponse1.charges) && Objects.equals(this.exchangeRateInformation, obWriteDataInternationalConsentResponse1.exchangeRateInformation) && Objects.equals(this.initiation, obWriteDataInternationalConsentResponse1.initiation) && Objects.equals(this.authorisation, obWriteDataInternationalConsentResponse1.authorisation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.cutOffDateTime, this.expectedExecutionDateTime, this.expectedSettlementDateTime, this.charges, this.exchangeRateInformation, this.initiation, this.authorisation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDataInternationalConsentResponse1 {\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    cutOffDateTime: ").append(this.toIndentedString(this.cutOffDateTime)).append("\n");
        sb.append("    expectedExecutionDateTime: ").append(this.toIndentedString(this.expectedExecutionDateTime)).append("\n");
        sb.append("    expectedSettlementDateTime: ").append(this.toIndentedString(this.expectedSettlementDateTime)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    exchangeRateInformation: ").append(this.toIndentedString(this.exchangeRateInformation)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("    authorisation: ").append(this.toIndentedString(this.authorisation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

