/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import org.springframework.validation.annotation.Validated;
import uk.org.openbanking.datamodel.payment.OBCharge1;
import uk.org.openbanking.datamodel.payment.OBExternalStatus1Code;
import uk.org.openbanking.datamodel.payment.OBInternationalStandingOrder2;
import uk.org.openbanking.datamodel.payment.OBMultiAuthorisation1;

@Validated
public class OBWriteDataInternationalStandingOrderResponse2 {
    @JsonProperty(value="InternationalStandingOrderId")
    private String internationalStandingOrderId = null;
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private OBExternalStatus1Code status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="Charges")
    @Valid
    private List<OBCharge1> charges = null;
    @JsonProperty(value="Initiation")
    private OBInternationalStandingOrder2 initiation = null;
    @JsonProperty(value="MultiAuthorisation")
    private OBMultiAuthorisation1 multiAuthorisation = null;

    public OBWriteDataInternationalStandingOrderResponse2 internationalStandingOrderId(String internationalStandingOrderId) {
        this.internationalStandingOrderId = internationalStandingOrderId;
        return this;
    }

    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the international standing order resource.")
    @NotNull
    @Size(min=1, max=40)
    public String getInternationalStandingOrderId() {
        return this.internationalStandingOrderId;
    }

    public void setInternationalStandingOrderId(String internationalStandingOrderId) {
        this.internationalStandingOrderId = internationalStandingOrderId;
    }

    public OBWriteDataInternationalStandingOrderResponse2 consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the consent resource.")
    @NotNull
    @Size(min=1, max=128)
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBWriteDataInternationalStandingOrderResponse2 creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource was created. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBWriteDataInternationalStandingOrderResponse2 status(OBExternalStatus1Code status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBExternalStatus1Code getStatus() {
        return this.status;
    }

    public void setStatus(OBExternalStatus1Code status) {
        this.status = status;
    }

    public OBWriteDataInternationalStandingOrderResponse2 statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time at which the resource status was updated. All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    @NotNull
    @Valid
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWriteDataInternationalStandingOrderResponse2 charges(List<OBCharge1> charges) {
        this.charges = charges;
        return this;
    }

    public OBWriteDataInternationalStandingOrderResponse2 addChargesItem(OBCharge1 chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<OBCharge1>();
        }
        this.charges.add(chargesItem);
        return this;
    }

    @ApiModelProperty(value="Set of elements used to provide details of a charge for the payment initiation.")
    @Valid
    public List<OBCharge1> getCharges() {
        return this.charges;
    }

    public void setCharges(List<OBCharge1> charges) {
        this.charges = charges;
    }

    public OBWriteDataInternationalStandingOrderResponse2 initiation(OBInternationalStandingOrder2 initiation) {
        this.initiation = initiation;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public OBInternationalStandingOrder2 getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBInternationalStandingOrder2 initiation) {
        this.initiation = initiation;
    }

    public OBWriteDataInternationalStandingOrderResponse2 multiAuthorisation(OBMultiAuthorisation1 multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public OBMultiAuthorisation1 getMultiAuthorisation() {
        return this.multiAuthorisation;
    }

    public void setMultiAuthorisation(OBMultiAuthorisation1 multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDataInternationalStandingOrderResponse2 obWriteDataInternationalStandingOrderResponse2 = (OBWriteDataInternationalStandingOrderResponse2)o;
        return Objects.equals(this.internationalStandingOrderId, obWriteDataInternationalStandingOrderResponse2.internationalStandingOrderId) && Objects.equals(this.consentId, obWriteDataInternationalStandingOrderResponse2.consentId) && Objects.equals(this.creationDateTime, obWriteDataInternationalStandingOrderResponse2.creationDateTime) && Objects.equals((Object)this.status, (Object)obWriteDataInternationalStandingOrderResponse2.status) && Objects.equals(this.statusUpdateDateTime, obWriteDataInternationalStandingOrderResponse2.statusUpdateDateTime) && Objects.equals(this.charges, obWriteDataInternationalStandingOrderResponse2.charges) && Objects.equals(this.initiation, obWriteDataInternationalStandingOrderResponse2.initiation) && Objects.equals(this.multiAuthorisation, obWriteDataInternationalStandingOrderResponse2.multiAuthorisation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.internationalStandingOrderId, this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.charges, this.initiation, this.multiAuthorisation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDataInternationalStandingOrderResponse2 {\n");
        sb.append("    internationalStandingOrderId: ").append(this.toIndentedString(this.internationalStandingOrderId)).append("\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("    multiAuthorisation: ").append(this.toIndentedString(this.multiAuthorisation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

