/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Size;

@ApiModel(description="Supporting Data provided by TPP, when requesting SCA Exemption.")
public class OBWriteDomesticConsent3DataSCASupportData {
    @JsonProperty(value="RequestedSCAExemptionType")
    private RequestedSCAExemptionTypeEnum requestedSCAExemptionType = null;
    @JsonProperty(value="AppliedAuthenticationApproach")
    private AppliedAuthenticationApproachEnum appliedAuthenticationApproach = null;
    @JsonProperty(value="ReferencePaymentOrderId")
    private String referencePaymentOrderId = null;

    public OBWriteDomesticConsent3DataSCASupportData requestedSCAExemptionType(RequestedSCAExemptionTypeEnum requestedSCAExemptionType) {
        this.requestedSCAExemptionType = requestedSCAExemptionType;
        return this;
    }

    @ApiModelProperty(value="This field allows a PISP to request specific SCA Exemption for a Payment Initiation")
    public RequestedSCAExemptionTypeEnum getRequestedSCAExemptionType() {
        return this.requestedSCAExemptionType;
    }

    public void setRequestedSCAExemptionType(RequestedSCAExemptionTypeEnum requestedSCAExemptionType) {
        this.requestedSCAExemptionType = requestedSCAExemptionType;
    }

    public OBWriteDomesticConsent3DataSCASupportData appliedAuthenticationApproach(AppliedAuthenticationApproachEnum appliedAuthenticationApproach) {
        this.appliedAuthenticationApproach = appliedAuthenticationApproach;
        return this;
    }

    @ApiModelProperty(value="Specifies a character string with a maximum length of 40 characters. Usage: This field indicates whether the PSU was subject to SCA performed by the TPP")
    public AppliedAuthenticationApproachEnum getAppliedAuthenticationApproach() {
        return this.appliedAuthenticationApproach;
    }

    public void setAppliedAuthenticationApproach(AppliedAuthenticationApproachEnum appliedAuthenticationApproach) {
        this.appliedAuthenticationApproach = appliedAuthenticationApproach;
    }

    public OBWriteDomesticConsent3DataSCASupportData referencePaymentOrderId(String referencePaymentOrderId) {
        this.referencePaymentOrderId = referencePaymentOrderId;
        return this;
    }

    @Size(min=1, max=128)
    @ApiModelProperty(value="Specifies a character string with a maximum length of 140 characters. Usage: If the payment is recurring then the transaction identifier of the previous payment occurrence so that the ASPSP can verify that the PISP, amount and the payee are the same as the previous occurrence.")
    public String getReferencePaymentOrderId() {
        return this.referencePaymentOrderId;
    }

    public void setReferencePaymentOrderId(String referencePaymentOrderId) {
        this.referencePaymentOrderId = referencePaymentOrderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDomesticConsent3DataSCASupportData obWriteDomesticConsent3DataSCASupportData = (OBWriteDomesticConsent3DataSCASupportData)o;
        return Objects.equals((Object)this.requestedSCAExemptionType, (Object)obWriteDomesticConsent3DataSCASupportData.requestedSCAExemptionType) && Objects.equals((Object)this.appliedAuthenticationApproach, (Object)obWriteDomesticConsent3DataSCASupportData.appliedAuthenticationApproach) && Objects.equals(this.referencePaymentOrderId, obWriteDomesticConsent3DataSCASupportData.referencePaymentOrderId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestedSCAExemptionType, this.appliedAuthenticationApproach, this.referencePaymentOrderId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDomesticConsent3DataSCASupportData {\n");
        sb.append("    requestedSCAExemptionType: ").append(this.toIndentedString((Object)this.requestedSCAExemptionType)).append("\n");
        sb.append("    appliedAuthenticationApproach: ").append(this.toIndentedString((Object)this.appliedAuthenticationApproach)).append("\n");
        sb.append("    referencePaymentOrderId: ").append(this.toIndentedString(this.referencePaymentOrderId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AppliedAuthenticationApproachEnum {
        CA("CA"),
        SCA("SCA");

        private String value;

        private AppliedAuthenticationApproachEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AppliedAuthenticationApproachEnum fromValue(String text) {
            for (AppliedAuthenticationApproachEnum b : AppliedAuthenticationApproachEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum RequestedSCAExemptionTypeEnum {
        BILLPAYMENT("BillPayment"),
        CONTACTLESSTRAVEL("ContactlessTravel"),
        ECOMMERCEGOODS("EcommerceGoods"),
        ECOMMERCESERVICES("EcommerceServices"),
        KIOSK("Kiosk"),
        PARKING("Parking"),
        PARTYTOPARTY("PartyToParty");

        private String value;

        private RequestedSCAExemptionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RequestedSCAExemptionTypeEnum fromValue(String text) {
            for (RequestedSCAExemptionTypeEnum b : RequestedSCAExemptionTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

