/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBPostalAddress6;
import uk.org.openbanking.datamodel.payment.OBSupplementaryData1;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationCreditorAccount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationDebtorAccount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationInstructedAmount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationRemittanceInformation;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds from the debtor account to a creditor for a single scheduled domestic payment.")
public class OBWriteDomesticScheduled2DataInitiation {
    @JsonProperty(value="InstructionIdentification")
    private String instructionIdentification = null;
    @JsonProperty(value="EndToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="LocalInstrument")
    private String localInstrument = null;
    @JsonProperty(value="RequestedExecutionDateTime")
    private DateTime requestedExecutionDateTime = null;
    @JsonProperty(value="InstructedAmount")
    private OBWriteDomestic2DataInitiationInstructedAmount instructedAmount = null;
    @JsonProperty(value="DebtorAccount")
    private OBWriteDomestic2DataInitiationDebtorAccount debtorAccount = null;
    @JsonProperty(value="CreditorAccount")
    private OBWriteDomestic2DataInitiationCreditorAccount creditorAccount = null;
    @JsonProperty(value="CreditorPostalAddress")
    private OBPostalAddress6 creditorPostalAddress = null;
    @JsonProperty(value="RemittanceInformation")
    private OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;

    public OBWriteDomesticScheduled2DataInitiation instructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
        return this;
    }

    @NotNull
    @Size(min=1, max=35)
    @ApiModelProperty(required=true, value="Unique identification as assigned by an instructing party for an instructed party to unambiguously identify the instruction. Usage: the  instruction identification is a point to point reference that can be used between the instructing party and the instructed party to refer to the individual instruction. It can be included in several messages related to the instruction.")
    public String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public OBWriteDomesticScheduled2DataInitiation endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @Size(min=1, max=35)
    @ApiModelProperty(value="Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain. Usage: The end-to-end identification can be used for reconciliation or to link tasks relating to the transaction. It can be included in several messages related to the transaction. OB: The Faster Payments Scheme can only access 31 characters for the EndToEndIdentification field.")
    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public OBWriteDomesticScheduled2DataInitiation localInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public OBWriteDomesticScheduled2DataInitiation requestedExecutionDateTime(DateTime requestedExecutionDateTime) {
        this.requestedExecutionDateTime = requestedExecutionDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date at which the initiating party requests the clearing agent to process the payment.  Usage: This is the date on which the debtor's account is to be debited.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getRequestedExecutionDateTime() {
        return this.requestedExecutionDateTime;
    }

    public void setRequestedExecutionDateTime(DateTime requestedExecutionDateTime) {
        this.requestedExecutionDateTime = requestedExecutionDateTime;
    }

    public OBWriteDomesticScheduled2DataInitiation instructedAmount(OBWriteDomestic2DataInitiationInstructedAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteDomestic2DataInitiationInstructedAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBWriteDomestic2DataInitiationInstructedAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBWriteDomesticScheduled2DataInitiation debtorAccount(OBWriteDomestic2DataInitiationDebtorAccount debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomestic2DataInitiationDebtorAccount getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBWriteDomestic2DataInitiationDebtorAccount debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBWriteDomesticScheduled2DataInitiation creditorAccount(OBWriteDomestic2DataInitiationCreditorAccount creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteDomestic2DataInitiationCreditorAccount getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBWriteDomestic2DataInitiationCreditorAccount creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBWriteDomesticScheduled2DataInitiation creditorPostalAddress(OBPostalAddress6 creditorPostalAddress) {
        this.creditorPostalAddress = creditorPostalAddress;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBPostalAddress6 getCreditorPostalAddress() {
        return this.creditorPostalAddress;
    }

    public void setCreditorPostalAddress(OBPostalAddress6 creditorPostalAddress) {
        this.creditorPostalAddress = creditorPostalAddress;
    }

    public OBWriteDomesticScheduled2DataInitiation remittanceInformation(OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomestic2DataInitiationRemittanceInformation getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public OBWriteDomesticScheduled2DataInitiation supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDomesticScheduled2DataInitiation obWriteDomesticScheduled2DataInitiation = (OBWriteDomesticScheduled2DataInitiation)o;
        return Objects.equals(this.instructionIdentification, obWriteDomesticScheduled2DataInitiation.instructionIdentification) && Objects.equals(this.endToEndIdentification, obWriteDomesticScheduled2DataInitiation.endToEndIdentification) && Objects.equals(this.localInstrument, obWriteDomesticScheduled2DataInitiation.localInstrument) && Objects.equals(this.requestedExecutionDateTime, obWriteDomesticScheduled2DataInitiation.requestedExecutionDateTime) && Objects.equals(this.instructedAmount, obWriteDomesticScheduled2DataInitiation.instructedAmount) && Objects.equals(this.debtorAccount, obWriteDomesticScheduled2DataInitiation.debtorAccount) && Objects.equals(this.creditorAccount, obWriteDomesticScheduled2DataInitiation.creditorAccount) && Objects.equals(this.creditorPostalAddress, obWriteDomesticScheduled2DataInitiation.creditorPostalAddress) && Objects.equals(this.remittanceInformation, obWriteDomesticScheduled2DataInitiation.remittanceInformation) && Objects.equals(this.supplementaryData, obWriteDomesticScheduled2DataInitiation.supplementaryData);
    }

    public int hashCode() {
        return Objects.hash(this.instructionIdentification, this.endToEndIdentification, this.localInstrument, this.requestedExecutionDateTime, this.instructedAmount, this.debtorAccount, this.creditorAccount, this.creditorPostalAddress, this.remittanceInformation, this.supplementaryData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDomesticScheduled2DataInitiation {\n");
        sb.append("    instructionIdentification: ").append(this.toIndentedString(this.instructionIdentification)).append("\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    localInstrument: ").append(this.toIndentedString(this.localInstrument)).append("\n");
        sb.append("    requestedExecutionDateTime: ").append(this.toIndentedString(this.requestedExecutionDateTime)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorPostalAddress: ").append(this.toIndentedString(this.creditorPostalAddress)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

