/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticConsentResponse3DataCharges;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticResponse3DataMultiAuthorisation;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticScheduled2DataInitiation;

public class OBWriteDomesticScheduledResponse3Data {
    @JsonProperty(value="DomesticScheduledPaymentId")
    private String domesticScheduledPaymentId = null;
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private StatusEnum status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="ExpectedExecutionDateTime")
    private DateTime expectedExecutionDateTime = null;
    @JsonProperty(value="ExpectedSettlementDateTime")
    private DateTime expectedSettlementDateTime = null;
    @JsonProperty(value="Charges")
    private List<OBWriteDomesticConsentResponse3DataCharges> charges = null;
    @JsonProperty(value="Initiation")
    private OBWriteDomesticScheduled2DataInitiation initiation = null;
    @JsonProperty(value="MultiAuthorisation")
    private OBWriteDomesticResponse3DataMultiAuthorisation multiAuthorisation = null;

    public OBWriteDomesticScheduledResponse3Data domesticScheduledPaymentId(String domesticScheduledPaymentId) {
        this.domesticScheduledPaymentId = domesticScheduledPaymentId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the domestic schedule payment resource.")
    public String getDomesticScheduledPaymentId() {
        return this.domesticScheduledPaymentId;
    }

    public void setDomesticScheduledPaymentId(String domesticScheduledPaymentId) {
        this.domesticScheduledPaymentId = domesticScheduledPaymentId;
    }

    public OBWriteDomesticScheduledResponse3Data consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @NotNull
    @Size(min=1, max=128)
    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the consent resource.")
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBWriteDomesticScheduledResponse3Data creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the message was created.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBWriteDomesticScheduledResponse3Data status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Specifies the status of the payment order resource.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OBWriteDomesticScheduledResponse3Data statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the resource status was updated.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWriteDomesticScheduledResponse3Data expectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Expected execution date and time for the payment resource.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getExpectedExecutionDateTime() {
        return this.expectedExecutionDateTime;
    }

    public void setExpectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
    }

    public OBWriteDomesticScheduledResponse3Data expectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Expected settlement date and time for the payment resource.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getExpectedSettlementDateTime() {
        return this.expectedSettlementDateTime;
    }

    public void setExpectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
    }

    public OBWriteDomesticScheduledResponse3Data charges(List<OBWriteDomesticConsentResponse3DataCharges> charges) {
        this.charges = charges;
        return this;
    }

    public OBWriteDomesticScheduledResponse3Data addChargesItem(OBWriteDomesticConsentResponse3DataCharges chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<OBWriteDomesticConsentResponse3DataCharges>();
        }
        this.charges.add(chargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBWriteDomesticConsentResponse3DataCharges> getCharges() {
        return this.charges;
    }

    public void setCharges(List<OBWriteDomesticConsentResponse3DataCharges> charges) {
        this.charges = charges;
    }

    public OBWriteDomesticScheduledResponse3Data initiation(OBWriteDomesticScheduled2DataInitiation initiation) {
        this.initiation = initiation;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteDomesticScheduled2DataInitiation getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBWriteDomesticScheduled2DataInitiation initiation) {
        this.initiation = initiation;
    }

    public OBWriteDomesticScheduledResponse3Data multiAuthorisation(OBWriteDomesticResponse3DataMultiAuthorisation multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomesticResponse3DataMultiAuthorisation getMultiAuthorisation() {
        return this.multiAuthorisation;
    }

    public void setMultiAuthorisation(OBWriteDomesticResponse3DataMultiAuthorisation multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDomesticScheduledResponse3Data obWriteDomesticScheduledResponse3Data = (OBWriteDomesticScheduledResponse3Data)o;
        return Objects.equals(this.domesticScheduledPaymentId, obWriteDomesticScheduledResponse3Data.domesticScheduledPaymentId) && Objects.equals(this.consentId, obWriteDomesticScheduledResponse3Data.consentId) && Objects.equals(this.creationDateTime, obWriteDomesticScheduledResponse3Data.creationDateTime) && Objects.equals((Object)this.status, (Object)obWriteDomesticScheduledResponse3Data.status) && Objects.equals(this.statusUpdateDateTime, obWriteDomesticScheduledResponse3Data.statusUpdateDateTime) && Objects.equals(this.expectedExecutionDateTime, obWriteDomesticScheduledResponse3Data.expectedExecutionDateTime) && Objects.equals(this.expectedSettlementDateTime, obWriteDomesticScheduledResponse3Data.expectedSettlementDateTime) && Objects.equals(this.charges, obWriteDomesticScheduledResponse3Data.charges) && Objects.equals(this.initiation, obWriteDomesticScheduledResponse3Data.initiation) && Objects.equals(this.multiAuthorisation, obWriteDomesticScheduledResponse3Data.multiAuthorisation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domesticScheduledPaymentId, this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.expectedExecutionDateTime, this.expectedSettlementDateTime, this.charges, this.initiation, this.multiAuthorisation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDomesticScheduledResponse3Data {\n");
        sb.append("    domesticScheduledPaymentId: ").append(this.toIndentedString(this.domesticScheduledPaymentId)).append("\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    expectedExecutionDateTime: ").append(this.toIndentedString(this.expectedExecutionDateTime)).append("\n");
        sb.append("    expectedSettlementDateTime: ").append(this.toIndentedString(this.expectedSettlementDateTime)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("    multiAuthorisation: ").append(this.toIndentedString(this.multiAuthorisation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        CANCELLED("Cancelled"),
        INITIATIONCOMPLETED("InitiationCompleted"),
        INITIATIONFAILED("InitiationFailed"),
        INITIATIONPENDING("InitiationPending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

