/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticConsentResponse3DataCharges;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticResponse3DataMultiAuthorisation;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticStandingOrder3DataInitiation;

public class OBWriteDomesticStandingOrderResponse4Data {
    @JsonProperty(value="DomesticStandingOrderId")
    private String domesticStandingOrderId = null;
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private StatusEnum status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="Charges")
    private List<OBWriteDomesticConsentResponse3DataCharges> charges = null;
    @JsonProperty(value="Initiation")
    private OBWriteDomesticStandingOrder3DataInitiation initiation = null;
    @JsonProperty(value="MultiAuthorisation")
    private OBWriteDomesticResponse3DataMultiAuthorisation multiAuthorisation = null;

    public OBWriteDomesticStandingOrderResponse4Data domesticStandingOrderId(String domesticStandingOrderId) {
        this.domesticStandingOrderId = domesticStandingOrderId;
        return this;
    }

    @NotNull
    @Size(min=1, max=40)
    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the domestic standing order resource.")
    public String getDomesticStandingOrderId() {
        return this.domesticStandingOrderId;
    }

    public void setDomesticStandingOrderId(String domesticStandingOrderId) {
        this.domesticStandingOrderId = domesticStandingOrderId;
    }

    public OBWriteDomesticStandingOrderResponse4Data consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @NotNull
    @Size(min=1, max=128)
    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the consent resource.")
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBWriteDomesticStandingOrderResponse4Data creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the resource was created.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBWriteDomesticStandingOrderResponse4Data status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Specifies the status of the payment order resource.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OBWriteDomesticStandingOrderResponse4Data statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the resource status was updated.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWriteDomesticStandingOrderResponse4Data charges(List<OBWriteDomesticConsentResponse3DataCharges> charges) {
        this.charges = charges;
        return this;
    }

    public OBWriteDomesticStandingOrderResponse4Data addChargesItem(OBWriteDomesticConsentResponse3DataCharges chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<OBWriteDomesticConsentResponse3DataCharges>();
        }
        this.charges.add(chargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBWriteDomesticConsentResponse3DataCharges> getCharges() {
        return this.charges;
    }

    public void setCharges(List<OBWriteDomesticConsentResponse3DataCharges> charges) {
        this.charges = charges;
    }

    public OBWriteDomesticStandingOrderResponse4Data initiation(OBWriteDomesticStandingOrder3DataInitiation initiation) {
        this.initiation = initiation;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteDomesticStandingOrder3DataInitiation getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBWriteDomesticStandingOrder3DataInitiation initiation) {
        this.initiation = initiation;
    }

    public OBWriteDomesticStandingOrderResponse4Data multiAuthorisation(OBWriteDomesticResponse3DataMultiAuthorisation multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomesticResponse3DataMultiAuthorisation getMultiAuthorisation() {
        return this.multiAuthorisation;
    }

    public void setMultiAuthorisation(OBWriteDomesticResponse3DataMultiAuthorisation multiAuthorisation) {
        this.multiAuthorisation = multiAuthorisation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteDomesticStandingOrderResponse4Data obWriteDomesticStandingOrderResponse4Data = (OBWriteDomesticStandingOrderResponse4Data)o;
        return Objects.equals(this.domesticStandingOrderId, obWriteDomesticStandingOrderResponse4Data.domesticStandingOrderId) && Objects.equals(this.consentId, obWriteDomesticStandingOrderResponse4Data.consentId) && Objects.equals(this.creationDateTime, obWriteDomesticStandingOrderResponse4Data.creationDateTime) && Objects.equals((Object)this.status, (Object)obWriteDomesticStandingOrderResponse4Data.status) && Objects.equals(this.statusUpdateDateTime, obWriteDomesticStandingOrderResponse4Data.statusUpdateDateTime) && Objects.equals(this.charges, obWriteDomesticStandingOrderResponse4Data.charges) && Objects.equals(this.initiation, obWriteDomesticStandingOrderResponse4Data.initiation) && Objects.equals(this.multiAuthorisation, obWriteDomesticStandingOrderResponse4Data.multiAuthorisation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domesticStandingOrderId, this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.charges, this.initiation, this.multiAuthorisation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteDomesticStandingOrderResponse4Data {\n");
        sb.append("    domesticStandingOrderId: ").append(this.toIndentedString(this.domesticStandingOrderId)).append("\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("    multiAuthorisation: ").append(this.toIndentedString(this.multiAuthorisation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        CANCELLED("Cancelled"),
        INITIATIONCOMPLETED("InitiationCompleted"),
        INITIATIONFAILED("InitiationFailed"),
        INITIATIONPENDING("InitiationPending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

