/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBSupplementaryData1;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationDebtorAccount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationRemittanceInformation;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds using a payment file.")
public class OBWriteFile2DataInitiation {
    @JsonProperty(value="FileType")
    private String fileType = null;
    @JsonProperty(value="FileHash")
    private String fileHash = null;
    @JsonProperty(value="FileReference")
    private String fileReference = null;
    @JsonProperty(value="NumberOfTransactions")
    private String numberOfTransactions = null;
    @JsonProperty(value="ControlSum")
    private BigDecimal controlSum = null;
    @JsonProperty(value="RequestedExecutionDateTime")
    private DateTime requestedExecutionDateTime = null;
    @JsonProperty(value="LocalInstrument")
    private String localInstrument = null;
    @JsonProperty(value="DebtorAccount")
    private OBWriteDomestic2DataInitiationDebtorAccount debtorAccount = null;
    @JsonProperty(value="RemittanceInformation")
    private OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;

    public OBWriteFile2DataInitiation fileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Specifies the payment file type.")
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public OBWriteFile2DataInitiation fileHash(String fileHash) {
        this.fileHash = fileHash;
        return this;
    }

    @NotNull
    @Size(min=1, max=44)
    @ApiModelProperty(required=true, value="A base64 encoding of a SHA256 hash of the file to be uploaded.")
    public String getFileHash() {
        return this.fileHash;
    }

    public void setFileHash(String fileHash) {
        this.fileHash = fileHash;
    }

    public OBWriteFile2DataInitiation fileReference(String fileReference) {
        this.fileReference = fileReference;
        return this;
    }

    @Size(min=1, max=40)
    @ApiModelProperty(value="Reference for the file.")
    public String getFileReference() {
        return this.fileReference;
    }

    public void setFileReference(String fileReference) {
        this.fileReference = fileReference;
    }

    public OBWriteFile2DataInitiation numberOfTransactions(String numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    @Pattern(regexp="[0-9]{1,15}")
    @ApiModelProperty(value="Number of individual transactions contained in the payment information group.")
    public String getNumberOfTransactions() {
        return this.numberOfTransactions;
    }

    public void setNumberOfTransactions(String numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
    }

    public OBWriteFile2DataInitiation controlSum(BigDecimal controlSum) {
        this.controlSum = controlSum;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Total of all individual amounts included in the group, irrespective of currencies.")
    public BigDecimal getControlSum() {
        return this.controlSum;
    }

    public void setControlSum(BigDecimal controlSum) {
        this.controlSum = controlSum;
    }

    public OBWriteFile2DataInitiation requestedExecutionDateTime(DateTime requestedExecutionDateTime) {
        this.requestedExecutionDateTime = requestedExecutionDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Date at which the initiating party requests the clearing agent to process the payment.  Usage: This is the date on which the debtor's account is to be debited.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getRequestedExecutionDateTime() {
        return this.requestedExecutionDateTime;
    }

    public void setRequestedExecutionDateTime(DateTime requestedExecutionDateTime) {
        this.requestedExecutionDateTime = requestedExecutionDateTime;
    }

    public OBWriteFile2DataInitiation localInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public OBWriteFile2DataInitiation debtorAccount(OBWriteDomestic2DataInitiationDebtorAccount debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomestic2DataInitiationDebtorAccount getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBWriteDomestic2DataInitiationDebtorAccount debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBWriteFile2DataInitiation remittanceInformation(OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomestic2DataInitiationRemittanceInformation getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public OBWriteFile2DataInitiation supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteFile2DataInitiation obWriteFile2DataInitiation = (OBWriteFile2DataInitiation)o;
        return Objects.equals(this.fileType, obWriteFile2DataInitiation.fileType) && Objects.equals(this.fileHash, obWriteFile2DataInitiation.fileHash) && Objects.equals(this.fileReference, obWriteFile2DataInitiation.fileReference) && Objects.equals(this.numberOfTransactions, obWriteFile2DataInitiation.numberOfTransactions) && Objects.equals(this.controlSum, obWriteFile2DataInitiation.controlSum) && Objects.equals(this.requestedExecutionDateTime, obWriteFile2DataInitiation.requestedExecutionDateTime) && Objects.equals(this.localInstrument, obWriteFile2DataInitiation.localInstrument) && Objects.equals(this.debtorAccount, obWriteFile2DataInitiation.debtorAccount) && Objects.equals(this.remittanceInformation, obWriteFile2DataInitiation.remittanceInformation) && Objects.equals(this.supplementaryData, obWriteFile2DataInitiation.supplementaryData);
    }

    public int hashCode() {
        return Objects.hash(this.fileType, this.fileHash, this.fileReference, this.numberOfTransactions, this.controlSum, this.requestedExecutionDateTime, this.localInstrument, this.debtorAccount, this.remittanceInformation, this.supplementaryData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteFile2DataInitiation {\n");
        sb.append("    fileType: ").append(this.toIndentedString(this.fileType)).append("\n");
        sb.append("    fileHash: ").append(this.toIndentedString(this.fileHash)).append("\n");
        sb.append("    fileReference: ").append(this.toIndentedString(this.fileReference)).append("\n");
        sb.append("    numberOfTransactions: ").append(this.toIndentedString(this.numberOfTransactions)).append("\n");
        sb.append("    controlSum: ").append(this.toIndentedString(this.controlSum)).append("\n");
        sb.append("    requestedExecutionDateTime: ").append(this.toIndentedString(this.requestedExecutionDateTime)).append("\n");
        sb.append("    localInstrument: ").append(this.toIndentedString(this.localInstrument)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

