/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticConsent3DataAuthorisation;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticConsent3DataSCASupportData;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticConsentResponse3DataCharges;
import uk.org.openbanking.datamodel.payment.OBWriteFile2DataInitiation;

public class OBWriteFileConsentResponse3Data {
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private StatusEnum status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="CutOffDateTime")
    private DateTime cutOffDateTime = null;
    @JsonProperty(value="Charges")
    private List<OBWriteDomesticConsentResponse3DataCharges> charges = null;
    @JsonProperty(value="Initiation")
    private OBWriteFile2DataInitiation initiation = null;
    @JsonProperty(value="Authorisation")
    private OBWriteDomesticConsent3DataAuthorisation authorisation = null;
    @JsonProperty(value="SCASupportData")
    private OBWriteDomesticConsent3DataSCASupportData scASupportData = null;

    public OBWriteFileConsentResponse3Data consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @NotNull
    @Size(min=1, max=128)
    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the consent resource.")
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBWriteFileConsentResponse3Data creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the resource was created.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBWriteFileConsentResponse3Data status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Specifies the status of consent resource in code form.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OBWriteFileConsentResponse3Data statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the consent resource status was updated.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWriteFileConsentResponse3Data cutOffDateTime(DateTime cutOffDateTime) {
        this.cutOffDateTime = cutOffDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Specified cut-off date and time for the payment consent.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getCutOffDateTime() {
        return this.cutOffDateTime;
    }

    public void setCutOffDateTime(DateTime cutOffDateTime) {
        this.cutOffDateTime = cutOffDateTime;
    }

    public OBWriteFileConsentResponse3Data charges(List<OBWriteDomesticConsentResponse3DataCharges> charges) {
        this.charges = charges;
        return this;
    }

    public OBWriteFileConsentResponse3Data addChargesItem(OBWriteDomesticConsentResponse3DataCharges chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<OBWriteDomesticConsentResponse3DataCharges>();
        }
        this.charges.add(chargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBWriteDomesticConsentResponse3DataCharges> getCharges() {
        return this.charges;
    }

    public void setCharges(List<OBWriteDomesticConsentResponse3DataCharges> charges) {
        this.charges = charges;
    }

    public OBWriteFileConsentResponse3Data initiation(OBWriteFile2DataInitiation initiation) {
        this.initiation = initiation;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteFile2DataInitiation getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBWriteFile2DataInitiation initiation) {
        this.initiation = initiation;
    }

    public OBWriteFileConsentResponse3Data authorisation(OBWriteDomesticConsent3DataAuthorisation authorisation) {
        this.authorisation = authorisation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomesticConsent3DataAuthorisation getAuthorisation() {
        return this.authorisation;
    }

    public void setAuthorisation(OBWriteDomesticConsent3DataAuthorisation authorisation) {
        this.authorisation = authorisation;
    }

    public OBWriteFileConsentResponse3Data scASupportData(OBWriteDomesticConsent3DataSCASupportData scASupportData) {
        this.scASupportData = scASupportData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomesticConsent3DataSCASupportData getScASupportData() {
        return this.scASupportData;
    }

    public void setScASupportData(OBWriteDomesticConsent3DataSCASupportData scASupportData) {
        this.scASupportData = scASupportData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteFileConsentResponse3Data obWriteFileConsentResponse3Data = (OBWriteFileConsentResponse3Data)o;
        return Objects.equals(this.consentId, obWriteFileConsentResponse3Data.consentId) && Objects.equals(this.creationDateTime, obWriteFileConsentResponse3Data.creationDateTime) && Objects.equals((Object)this.status, (Object)obWriteFileConsentResponse3Data.status) && Objects.equals(this.statusUpdateDateTime, obWriteFileConsentResponse3Data.statusUpdateDateTime) && Objects.equals(this.cutOffDateTime, obWriteFileConsentResponse3Data.cutOffDateTime) && Objects.equals(this.charges, obWriteFileConsentResponse3Data.charges) && Objects.equals(this.initiation, obWriteFileConsentResponse3Data.initiation) && Objects.equals(this.authorisation, obWriteFileConsentResponse3Data.authorisation) && Objects.equals(this.scASupportData, obWriteFileConsentResponse3Data.scASupportData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.cutOffDateTime, this.charges, this.initiation, this.authorisation, this.scASupportData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteFileConsentResponse3Data {\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    cutOffDateTime: ").append(this.toIndentedString(this.cutOffDateTime)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("    authorisation: ").append(this.toIndentedString(this.authorisation)).append("\n");
        sb.append("    scASupportData: ").append(this.toIndentedString(this.scASupportData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        AUTHORISED("Authorised"),
        AWAITINGAUTHORISATION("AwaitingAuthorisation"),
        AWAITINGUPLOAD("AwaitingUpload"),
        CONSUMED("Consumed"),
        REJECTED("Rejected");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

