/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import uk.org.openbanking.datamodel.payment.OBChargeBearerType1Code;
import uk.org.openbanking.datamodel.payment.OBSupplementaryData1;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationCreditorAccount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationDebtorAccount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationInstructedAmount;
import uk.org.openbanking.datamodel.payment.OBWriteDomestic2DataInitiationRemittanceInformation;
import uk.org.openbanking.datamodel.payment.OBWriteInternational2DataInitiationCreditor;
import uk.org.openbanking.datamodel.payment.OBWriteInternational2DataInitiationCreditorAgent;
import uk.org.openbanking.datamodel.payment.OBWriteInternational2DataInitiationExchangeRateInformation;

@ApiModel(description="The Initiation payload is sent by the initiating party to the ASPSP. It is used to request movement of funds from the debtor account to a creditor for a single international payment.")
public class OBWriteInternational2DataInitiation {
    @JsonProperty(value="InstructionIdentification")
    private String instructionIdentification = null;
    @JsonProperty(value="EndToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="LocalInstrument")
    private String localInstrument = null;
    @JsonProperty(value="InstructionPriority")
    private InstructionPriorityEnum instructionPriority = null;
    @JsonProperty(value="Purpose")
    private String purpose = null;
    @JsonProperty(value="ChargeBearer")
    private OBChargeBearerType1Code chargeBearer = null;
    @JsonProperty(value="CurrencyOfTransfer")
    private String currencyOfTransfer = null;
    @JsonProperty(value="InstructedAmount")
    private OBWriteDomestic2DataInitiationInstructedAmount instructedAmount = null;
    @JsonProperty(value="ExchangeRateInformation")
    private OBWriteInternational2DataInitiationExchangeRateInformation exchangeRateInformation = null;
    @JsonProperty(value="DebtorAccount")
    private OBWriteDomestic2DataInitiationDebtorAccount debtorAccount = null;
    @JsonProperty(value="Creditor")
    private OBWriteInternational2DataInitiationCreditor creditor = null;
    @JsonProperty(value="CreditorAgent")
    private OBWriteInternational2DataInitiationCreditorAgent creditorAgent = null;
    @JsonProperty(value="CreditorAccount")
    private OBWriteDomestic2DataInitiationCreditorAccount creditorAccount = null;
    @JsonProperty(value="RemittanceInformation")
    private OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation = null;
    @JsonProperty(value="SupplementaryData")
    private OBSupplementaryData1 supplementaryData = null;

    public OBWriteInternational2DataInitiation instructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
        return this;
    }

    @NotNull
    @Size(min=1, max=35)
    @ApiModelProperty(required=true, value="Unique identification as assigned by an instructing party for an instructed party to unambiguously identify the instruction. Usage: the  instruction identification is a point to point reference that can be used between the instructing party and the instructed party to refer to the individual instruction. It can be included in several messages related to the instruction.")
    public String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public OBWriteInternational2DataInitiation endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @NotNull
    @Size(min=1, max=35)
    @ApiModelProperty(required=true, value="Unique identification assigned by the initiating party to unambiguously identify the transaction. This identification is passed on, unchanged, throughout the entire end-to-end chain. Usage: The end-to-end identification can be used for reconciliation or to link tasks relating to the transaction. It can be included in several messages related to the transaction. OB: The Faster Payments Scheme can only access 31 characters for the EndToEndIdentification field.")
    public String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public OBWriteInternational2DataInitiation localInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public OBWriteInternational2DataInitiation instructionPriority(InstructionPriorityEnum instructionPriority) {
        this.instructionPriority = instructionPriority;
        return this;
    }

    @ApiModelProperty(value="Indicator of the urgency or order of importance that the instructing party would like the instructed party to apply to the processing of the instruction.")
    public InstructionPriorityEnum getInstructionPriority() {
        return this.instructionPriority;
    }

    public void setInstructionPriority(InstructionPriorityEnum instructionPriority) {
        this.instructionPriority = instructionPriority;
    }

    public OBWriteInternational2DataInitiation purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(value="Specifies the external purpose code in the format of character string with a maximum length of 4 characters. The list of valid codes is an external code list published separately. External code sets can be downloaded from www.iso20022.org.")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public OBWriteInternational2DataInitiation chargeBearer(OBChargeBearerType1Code chargeBearer) {
        this.chargeBearer = chargeBearer;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBChargeBearerType1Code getChargeBearer() {
        return this.chargeBearer;
    }

    public void setChargeBearer(OBChargeBearerType1Code chargeBearer) {
        this.chargeBearer = chargeBearer;
    }

    public OBWriteInternational2DataInitiation currencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
        return this;
    }

    @NotNull
    @Pattern(regexp="^[A-Z]{3,3}$")
    @ApiModelProperty(required=true, value="Specifies the currency of the to be transferred amount, which is different from the currency of the debtor's account.")
    public String getCurrencyOfTransfer() {
        return this.currencyOfTransfer;
    }

    public void setCurrencyOfTransfer(String currencyOfTransfer) {
        this.currencyOfTransfer = currencyOfTransfer;
    }

    public OBWriteInternational2DataInitiation instructedAmount(OBWriteDomestic2DataInitiationInstructedAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteDomestic2DataInitiationInstructedAmount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(OBWriteDomestic2DataInitiationInstructedAmount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public OBWriteInternational2DataInitiation exchangeRateInformation(OBWriteInternational2DataInitiationExchangeRateInformation exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteInternational2DataInitiationExchangeRateInformation getExchangeRateInformation() {
        return this.exchangeRateInformation;
    }

    public void setExchangeRateInformation(OBWriteInternational2DataInitiationExchangeRateInformation exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
    }

    public OBWriteInternational2DataInitiation debtorAccount(OBWriteDomestic2DataInitiationDebtorAccount debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomestic2DataInitiationDebtorAccount getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(OBWriteDomestic2DataInitiationDebtorAccount debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public OBWriteInternational2DataInitiation creditor(OBWriteInternational2DataInitiationCreditor creditor) {
        this.creditor = creditor;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteInternational2DataInitiationCreditor getCreditor() {
        return this.creditor;
    }

    public void setCreditor(OBWriteInternational2DataInitiationCreditor creditor) {
        this.creditor = creditor;
    }

    public OBWriteInternational2DataInitiation creditorAgent(OBWriteInternational2DataInitiationCreditorAgent creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteInternational2DataInitiationCreditorAgent getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(OBWriteInternational2DataInitiationCreditorAgent creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public OBWriteInternational2DataInitiation creditorAccount(OBWriteDomestic2DataInitiationCreditorAccount creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteDomestic2DataInitiationCreditorAccount getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(OBWriteDomestic2DataInitiationCreditorAccount creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public OBWriteInternational2DataInitiation remittanceInformation(OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomestic2DataInitiationRemittanceInformation getRemittanceInformation() {
        return this.remittanceInformation;
    }

    public void setRemittanceInformation(OBWriteDomestic2DataInitiationRemittanceInformation remittanceInformation) {
        this.remittanceInformation = remittanceInformation;
    }

    public OBWriteInternational2DataInitiation supplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBSupplementaryData1 getSupplementaryData() {
        return this.supplementaryData;
    }

    public void setSupplementaryData(OBSupplementaryData1 supplementaryData) {
        this.supplementaryData = supplementaryData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteInternational2DataInitiation obWriteInternational2DataInitiation = (OBWriteInternational2DataInitiation)o;
        return Objects.equals(this.instructionIdentification, obWriteInternational2DataInitiation.instructionIdentification) && Objects.equals(this.endToEndIdentification, obWriteInternational2DataInitiation.endToEndIdentification) && Objects.equals(this.localInstrument, obWriteInternational2DataInitiation.localInstrument) && Objects.equals((Object)this.instructionPriority, (Object)obWriteInternational2DataInitiation.instructionPriority) && Objects.equals(this.purpose, obWriteInternational2DataInitiation.purpose) && Objects.equals((Object)this.chargeBearer, (Object)obWriteInternational2DataInitiation.chargeBearer) && Objects.equals(this.currencyOfTransfer, obWriteInternational2DataInitiation.currencyOfTransfer) && Objects.equals(this.instructedAmount, obWriteInternational2DataInitiation.instructedAmount) && Objects.equals(this.exchangeRateInformation, obWriteInternational2DataInitiation.exchangeRateInformation) && Objects.equals(this.debtorAccount, obWriteInternational2DataInitiation.debtorAccount) && Objects.equals(this.creditor, obWriteInternational2DataInitiation.creditor) && Objects.equals(this.creditorAgent, obWriteInternational2DataInitiation.creditorAgent) && Objects.equals(this.creditorAccount, obWriteInternational2DataInitiation.creditorAccount) && Objects.equals(this.remittanceInformation, obWriteInternational2DataInitiation.remittanceInformation) && Objects.equals(this.supplementaryData, obWriteInternational2DataInitiation.supplementaryData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.instructionIdentification, this.endToEndIdentification, this.localInstrument, this.instructionPriority, this.purpose, this.chargeBearer, this.currencyOfTransfer, this.instructedAmount, this.exchangeRateInformation, this.debtorAccount, this.creditor, this.creditorAgent, this.creditorAccount, this.remittanceInformation, this.supplementaryData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteInternational2DataInitiation {\n");
        sb.append("    instructionIdentification: ").append(this.toIndentedString(this.instructionIdentification)).append("\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    localInstrument: ").append(this.toIndentedString(this.localInstrument)).append("\n");
        sb.append("    instructionPriority: ").append(this.toIndentedString((Object)this.instructionPriority)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    chargeBearer: ").append(this.toIndentedString((Object)this.chargeBearer)).append("\n");
        sb.append("    currencyOfTransfer: ").append(this.toIndentedString(this.currencyOfTransfer)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    exchangeRateInformation: ").append(this.toIndentedString(this.exchangeRateInformation)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditor: ").append(this.toIndentedString(this.creditor)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    remittanceInformation: ").append(this.toIndentedString(this.remittanceInformation)).append("\n");
        sb.append("    supplementaryData: ").append(this.toIndentedString(this.supplementaryData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InstructionPriorityEnum {
        NORMAL("Normal"),
        URGENT("Urgent");

        private String value;

        private InstructionPriorityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InstructionPriorityEnum fromValue(String text) {
            for (InstructionPriorityEnum b : InstructionPriorityEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

