/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.joda.time.DateTime;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticConsent3DataAuthorisation;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticConsent3DataSCASupportData;
import uk.org.openbanking.datamodel.payment.OBWriteDomesticConsentResponse3DataCharges;
import uk.org.openbanking.datamodel.payment.OBWriteInternational2DataInitiation;
import uk.org.openbanking.datamodel.payment.OBWriteInternationalConsentResponse3DataExchangeRateInformation;

public class OBWriteInternationalConsentResponse3Data {
    @JsonProperty(value="ConsentId")
    private String consentId = null;
    @JsonProperty(value="CreationDateTime")
    private DateTime creationDateTime = null;
    @JsonProperty(value="Status")
    private StatusEnum status = null;
    @JsonProperty(value="StatusUpdateDateTime")
    private DateTime statusUpdateDateTime = null;
    @JsonProperty(value="CutOffDateTime")
    private DateTime cutOffDateTime = null;
    @JsonProperty(value="ExpectedExecutionDateTime")
    private DateTime expectedExecutionDateTime = null;
    @JsonProperty(value="ExpectedSettlementDateTime")
    private DateTime expectedSettlementDateTime = null;
    @JsonProperty(value="Charges")
    private List<OBWriteDomesticConsentResponse3DataCharges> charges = null;
    @JsonProperty(value="ExchangeRateInformation")
    private OBWriteInternationalConsentResponse3DataExchangeRateInformation exchangeRateInformation = null;
    @JsonProperty(value="Initiation")
    private OBWriteInternational2DataInitiation initiation = null;
    @JsonProperty(value="Authorisation")
    private OBWriteDomesticConsent3DataAuthorisation authorisation = null;
    @JsonProperty(value="SCASupportData")
    private OBWriteDomesticConsent3DataSCASupportData scASupportData = null;

    public OBWriteInternationalConsentResponse3Data consentId(String consentId) {
        this.consentId = consentId;
        return this;
    }

    @NotNull
    @Size(min=1, max=128)
    @ApiModelProperty(required=true, value="OB: Unique identification as assigned by the ASPSP to uniquely identify the consent resource.")
    public String getConsentId() {
        return this.consentId;
    }

    public void setConsentId(String consentId) {
        this.consentId = consentId;
    }

    public OBWriteInternationalConsentResponse3Data creationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the resource was created.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public OBWriteInternationalConsentResponse3Data status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @NotNull
    @ApiModelProperty(required=true, value="Specifies the status of consent resource in code form.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OBWriteInternationalConsentResponse3Data statusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="Date and time at which the resource status was updated.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getStatusUpdateDateTime() {
        return this.statusUpdateDateTime;
    }

    public void setStatusUpdateDateTime(DateTime statusUpdateDateTime) {
        this.statusUpdateDateTime = statusUpdateDateTime;
    }

    public OBWriteInternationalConsentResponse3Data cutOffDateTime(DateTime cutOffDateTime) {
        this.cutOffDateTime = cutOffDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Specified cut-off date and time for the payment consent.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getCutOffDateTime() {
        return this.cutOffDateTime;
    }

    public void setCutOffDateTime(DateTime cutOffDateTime) {
        this.cutOffDateTime = cutOffDateTime;
    }

    public OBWriteInternationalConsentResponse3Data expectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Expected execution date and time for the payment resource.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getExpectedExecutionDateTime() {
        return this.expectedExecutionDateTime;
    }

    public void setExpectedExecutionDateTime(DateTime expectedExecutionDateTime) {
        this.expectedExecutionDateTime = expectedExecutionDateTime;
    }

    public OBWriteInternationalConsentResponse3Data expectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
        return this;
    }

    @Valid
    @ApiModelProperty(value="Expected settlement date and time for the payment resource.All dates in the JSON payloads are represented in ISO 8601 date-time format.  All date-time fields in responses must include the timezone. An example is below: 2017-04-05T10:43:07+00:00")
    public DateTime getExpectedSettlementDateTime() {
        return this.expectedSettlementDateTime;
    }

    public void setExpectedSettlementDateTime(DateTime expectedSettlementDateTime) {
        this.expectedSettlementDateTime = expectedSettlementDateTime;
    }

    public OBWriteInternationalConsentResponse3Data charges(List<OBWriteDomesticConsentResponse3DataCharges> charges) {
        this.charges = charges;
        return this;
    }

    public OBWriteInternationalConsentResponse3Data addChargesItem(OBWriteDomesticConsentResponse3DataCharges chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<OBWriteDomesticConsentResponse3DataCharges>();
        }
        this.charges.add(chargesItem);
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public List<OBWriteDomesticConsentResponse3DataCharges> getCharges() {
        return this.charges;
    }

    public void setCharges(List<OBWriteDomesticConsentResponse3DataCharges> charges) {
        this.charges = charges;
    }

    public OBWriteInternationalConsentResponse3Data exchangeRateInformation(OBWriteInternationalConsentResponse3DataExchangeRateInformation exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteInternationalConsentResponse3DataExchangeRateInformation getExchangeRateInformation() {
        return this.exchangeRateInformation;
    }

    public void setExchangeRateInformation(OBWriteInternationalConsentResponse3DataExchangeRateInformation exchangeRateInformation) {
        this.exchangeRateInformation = exchangeRateInformation;
    }

    public OBWriteInternationalConsentResponse3Data initiation(OBWriteInternational2DataInitiation initiation) {
        this.initiation = initiation;
        return this;
    }

    @NotNull
    @Valid
    @ApiModelProperty(required=true, value="")
    public OBWriteInternational2DataInitiation getInitiation() {
        return this.initiation;
    }

    public void setInitiation(OBWriteInternational2DataInitiation initiation) {
        this.initiation = initiation;
    }

    public OBWriteInternationalConsentResponse3Data authorisation(OBWriteDomesticConsent3DataAuthorisation authorisation) {
        this.authorisation = authorisation;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomesticConsent3DataAuthorisation getAuthorisation() {
        return this.authorisation;
    }

    public void setAuthorisation(OBWriteDomesticConsent3DataAuthorisation authorisation) {
        this.authorisation = authorisation;
    }

    public OBWriteInternationalConsentResponse3Data scASupportData(OBWriteDomesticConsent3DataSCASupportData scASupportData) {
        this.scASupportData = scASupportData;
        return this;
    }

    @Valid
    @ApiModelProperty(value="")
    public OBWriteDomesticConsent3DataSCASupportData getScASupportData() {
        return this.scASupportData;
    }

    public void setScASupportData(OBWriteDomesticConsent3DataSCASupportData scASupportData) {
        this.scASupportData = scASupportData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWriteInternationalConsentResponse3Data obWriteInternationalConsentResponse3Data = (OBWriteInternationalConsentResponse3Data)o;
        return Objects.equals(this.consentId, obWriteInternationalConsentResponse3Data.consentId) && Objects.equals(this.creationDateTime, obWriteInternationalConsentResponse3Data.creationDateTime) && Objects.equals((Object)this.status, (Object)obWriteInternationalConsentResponse3Data.status) && Objects.equals(this.statusUpdateDateTime, obWriteInternationalConsentResponse3Data.statusUpdateDateTime) && Objects.equals(this.cutOffDateTime, obWriteInternationalConsentResponse3Data.cutOffDateTime) && Objects.equals(this.expectedExecutionDateTime, obWriteInternationalConsentResponse3Data.expectedExecutionDateTime) && Objects.equals(this.expectedSettlementDateTime, obWriteInternationalConsentResponse3Data.expectedSettlementDateTime) && Objects.equals(this.charges, obWriteInternationalConsentResponse3Data.charges) && Objects.equals(this.exchangeRateInformation, obWriteInternationalConsentResponse3Data.exchangeRateInformation) && Objects.equals(this.initiation, obWriteInternationalConsentResponse3Data.initiation) && Objects.equals(this.authorisation, obWriteInternationalConsentResponse3Data.authorisation) && Objects.equals(this.scASupportData, obWriteInternationalConsentResponse3Data.scASupportData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.consentId, this.creationDateTime, this.status, this.statusUpdateDateTime, this.cutOffDateTime, this.expectedExecutionDateTime, this.expectedSettlementDateTime, this.charges, this.exchangeRateInformation, this.initiation, this.authorisation, this.scASupportData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWriteInternationalConsentResponse3Data {\n");
        sb.append("    consentId: ").append(this.toIndentedString(this.consentId)).append("\n");
        sb.append("    creationDateTime: ").append(this.toIndentedString(this.creationDateTime)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusUpdateDateTime: ").append(this.toIndentedString(this.statusUpdateDateTime)).append("\n");
        sb.append("    cutOffDateTime: ").append(this.toIndentedString(this.cutOffDateTime)).append("\n");
        sb.append("    expectedExecutionDateTime: ").append(this.toIndentedString(this.expectedExecutionDateTime)).append("\n");
        sb.append("    expectedSettlementDateTime: ").append(this.toIndentedString(this.expectedSettlementDateTime)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    exchangeRateInformation: ").append(this.toIndentedString(this.exchangeRateInformation)).append("\n");
        sb.append("    initiation: ").append(this.toIndentedString(this.initiation)).append("\n");
        sb.append("    authorisation: ").append(this.toIndentedString(this.authorisation)).append("\n");
        sb.append("    scASupportData: ").append(this.toIndentedString(this.scASupportData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        AUTHORISED("Authorised"),
        AWAITINGAUTHORISATION("AwaitingAuthorisation"),
        CONSUMED("Consumed"),
        REJECTED("Rejected");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

