/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.payment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="Payment status details as per underlying Payment Rail.")
public class OBWritePaymentDetailsResponse1DataStatusDetail {
    @JsonProperty(value="LocalInstrument")
    private String localInstrument = null;
    @JsonProperty(value="Status")
    private String status = null;
    @JsonProperty(value="StatusReason")
    private StatusReasonEnum statusReason = null;
    @JsonProperty(value="StatusReasonDescription")
    private String statusReasonDescription = null;

    public OBWritePaymentDetailsResponse1DataStatusDetail localInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
        return this;
    }

    @ApiModelProperty(value="")
    public String getLocalInstrument() {
        return this.localInstrument;
    }

    public void setLocalInstrument(String localInstrument) {
        this.localInstrument = localInstrument;
    }

    public OBWritePaymentDetailsResponse1DataStatusDetail status(String status) {
        this.status = status;
        return this;
    }

    @NotNull
    @Size(min=1, max=128)
    @ApiModelProperty(required=true, value="Status of a transfer, as assigned by the transaction administrator.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public OBWritePaymentDetailsResponse1DataStatusDetail statusReason(StatusReasonEnum statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    @ApiModelProperty(value="Reason Code provided for the status of a transfer.")
    public StatusReasonEnum getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(StatusReasonEnum statusReason) {
        this.statusReason = statusReason;
    }

    public OBWritePaymentDetailsResponse1DataStatusDetail statusReasonDescription(String statusReasonDescription) {
        this.statusReasonDescription = statusReasonDescription;
        return this;
    }

    @Size(min=1, max=256)
    @ApiModelProperty(value="Reason provided for the status of a transfer.")
    public String getStatusReasonDescription() {
        return this.statusReasonDescription;
    }

    public void setStatusReasonDescription(String statusReasonDescription) {
        this.statusReasonDescription = statusReasonDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBWritePaymentDetailsResponse1DataStatusDetail obWritePaymentDetailsResponse1DataStatusDetail = (OBWritePaymentDetailsResponse1DataStatusDetail)o;
        return Objects.equals(this.localInstrument, obWritePaymentDetailsResponse1DataStatusDetail.localInstrument) && Objects.equals(this.status, obWritePaymentDetailsResponse1DataStatusDetail.status) && Objects.equals((Object)this.statusReason, (Object)obWritePaymentDetailsResponse1DataStatusDetail.statusReason) && Objects.equals(this.statusReasonDescription, obWritePaymentDetailsResponse1DataStatusDetail.statusReasonDescription);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.localInstrument, this.status, this.statusReason, this.statusReasonDescription});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OBWritePaymentDetailsResponse1DataStatusDetail {\n");
        sb.append("    localInstrument: ").append(this.toIndentedString(this.localInstrument)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    statusReason: ").append(this.toIndentedString((Object)this.statusReason)).append("\n");
        sb.append("    statusReasonDescription: ").append(this.toIndentedString(this.statusReasonDescription)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusReasonEnum {
        CANCELLED("Cancelled"),
        PENDINGFAILINGSETTLEMENT("PendingFailingSettlement"),
        PENDINGSETTLEMENT("PendingSettlement"),
        PROPRIETARY("Proprietary"),
        PROPRIETARYREJECTION("ProprietaryRejection"),
        SUSPENDED("Suspended"),
        UNMATCHED("Unmatched");

        private String value;

        private StatusReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusReasonEnum fromValue(String text) {
            for (StatusReasonEnum b : StatusReasonEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

