/*
 * Decompiled with CFR 0.152.
 */
package uk.org.openbanking.datamodel.service.converter;

import java.util.Collections;
import uk.org.openbanking.datamodel.account.OBAccount1;
import uk.org.openbanking.datamodel.account.OBAccount2;
import uk.org.openbanking.datamodel.account.OBBranchAndFinancialInstitutionIdentification2;
import uk.org.openbanking.datamodel.account.OBCashAccount1;
import uk.org.openbanking.datamodel.account.OBCashAccount3;
import uk.org.openbanking.datamodel.account.OBExternalAccountSubType1Code;
import uk.org.openbanking.datamodel.account.OBExternalAccountType1Code;
import uk.org.openbanking.datamodel.account.OBExternalFinancialInstitutionIdentification2Code;
import uk.org.openbanking.datamodel.payment.OBExternalAccountIdentification2Code;

public class OBAccountConverter {
    public static OBAccount1 toAccount1(OBAccount2 account2) {
        OBAccount1 account1 = new OBAccount1().accountId(account2.getAccountId()).currency(account2.getCurrency());
        if (account2.getNickname() != null) {
            account1.nickname(account2.getNickname());
        }
        if (account2.getAccount() != null && account2.getAccount().size() > 0) {
            OBCashAccount3 obAccount2Account = account2.getAccount().get(0);
            OBCashAccount1 obCashAccount1 = new OBCashAccount1().schemeName(OBAccountConverter.toOBExternalAccountIdentification2Code(obAccount2Account.getSchemeName())).identification(obAccount2Account.getIdentification());
            if (obAccount2Account.getName() != null) {
                obCashAccount1.name(obAccount2Account.getName());
            }
            if (obAccount2Account.getSecondaryIdentification() != null) {
                obCashAccount1.secondaryIdentification(obAccount2Account.getSecondaryIdentification());
            }
            account1.account(obCashAccount1);
        }
        if (account2.getServicer() != null) {
            account1.servicer(new OBBranchAndFinancialInstitutionIdentification2().schemeName(OBExternalFinancialInstitutionIdentification2Code.valueOf(account2.getServicer().getSchemeName())).identification(account2.getServicer().getIdentification()));
        }
        return account1;
    }

    public static OBAccount2 toAccount2(OBAccount1 account1) {
        OBAccount2 account2 = new OBAccount2().accountId(account1.getAccountId()).currency(account1.getCurrency()).accountSubType(OBExternalAccountSubType1Code.CURRENTACCOUNT).accountType(OBExternalAccountType1Code.PERSONAL);
        if (account1.getNickname() != null) {
            account2.nickname(account1.getNickname());
        }
        OBCashAccount3 account2Account = new OBCashAccount3().schemeName(account1.getAccount().getSchemeName().toString()).identification(account1.getAccount().getIdentification());
        if (account1.getAccount().getName() != null) {
            account2Account.name(account1.getAccount().getName());
        }
        if (account1.getAccount().getSecondaryIdentification() != null) {
            account2Account.secondaryIdentification(account1.getAccount().getSecondaryIdentification());
        }
        account2.account(Collections.singletonList(account2Account));
        if (account2.getServicer() != null) {
            account1.servicer(new OBBranchAndFinancialInstitutionIdentification2().schemeName(OBExternalFinancialInstitutionIdentification2Code.valueOf(account2.getServicer().getSchemeName())).identification(account2.getServicer().getIdentification()));
        }
        return account2;
    }

    private static OBExternalAccountIdentification2Code toOBExternalAccountIdentification2Code(String obExternalAccountIdentification3Code) {
        return OBExternalAccountIdentification2Code.valueOfReference(obExternalAccountIdentification3Code);
    }
}

