/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Phrase;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfPhrase
extends RtfElement {
    public static final byte[] PARAGRAPH_DEFAULTS = DocWriter.getISOBytes("\\pard");
    public static final byte[] PLAIN = DocWriter.getISOBytes("\\plain");
    public static final byte[] IN_TABLE = DocWriter.getISOBytes("\\intbl");
    public static final byte[] LINE_SPACING = DocWriter.getISOBytes("\\sl");
    protected ArrayList chunks = new ArrayList();
    private int lineLeading = 0;

    protected RtfPhrase(RtfDocument doc) {
        super(doc);
    }

    public RtfPhrase(RtfDocument doc, Phrase phrase) {
        super(doc);
        if (phrase == null) {
            return;
        }
        this.lineLeading = phrase.hasLeading() ? (int)((double)phrase.getLeading() * 20.0) : 0;
        RtfFont phraseFont = new RtfFont(null, phrase.getFont());
        for (int i = 0; i < phrase.size(); ++i) {
            Element chunk = (Element)phrase.get(i);
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(phraseFont.difference(((Chunk)chunk).getFont()));
            }
            try {
                RtfBasicElement[] rtfElements = doc.getMapper().mapElement(chunk);
                for (int j = 0; j < rtfElements.length; ++j) {
                    this.chunks.add(rtfElements[j]);
                }
                continue;
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        result.write(PARAGRAPH_DEFAULTS);
        result.write(PLAIN);
        if (this.inTable) {
            result.write(IN_TABLE);
        }
        if (this.lineLeading > 0) {
            result.write(LINE_SPACING);
            result.write(this.intToByteArray(this.lineLeading));
        }
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rbe = (RtfBasicElement)this.chunks.get(i);
            rbe.writeContent(result);
        }
    }

    @Override
    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setInTable(inTable);
        }
    }

    @Override
    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setInHeader(inHeader);
        }
    }

    @Override
    public void setRtfDocument(RtfDocument doc) {
        super.setRtfDocument(doc);
        for (int i = 0; i < this.chunks.size(); ++i) {
            ((RtfBasicElement)this.chunks.get(i)).setRtfDocument(this.document);
        }
    }
}

