/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFDataType;
import com.linuxense.javadbf.DBFUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class DBFMemoFile {
    private File memoFile = null;
    private Charset charset = null;
    private int blockSize = 512;
    private boolean fpt = false;

    protected DBFMemoFile(File memoFile, Charset charset) {
        this.memoFile = memoFile;
        this.charset = charset;
        this.fpt = memoFile.getName().toLowerCase().endsWith(".fpt");
        this.readBlockSize();
    }

    private void readBlockSize() {
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(this.memoFile, "r");
            if (this.isFPT()) {
                file.seek(6L);
                this.blockSize = file.readShort();
            } else {
                file.seek(20L);
                this.blockSize = DBFUtils.readLittleEndianShort(file);
            }
            if (this.blockSize == 0) {
                this.blockSize = 512;
            }
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                DBFUtils.close(file);
                throw throwable;
            }
        }
        DBFUtils.close(file);
    }

    private boolean isFPT() {
        return this.fpt;
    }

    protected String readText(int block) {
        return (String)this.readData(block, DBFDataType.MEMO);
    }

    protected byte[] readBinary(int block) {
        return (byte[])this.readData(block, DBFDataType.BINARY);
    }

    protected Object readData(int block, DBFDataType type) {
        String string;
        byte[] data;
        RandomAccessFile file;
        block16: {
            int endIndex;
            file = null;
            long blockStart = (long)this.blockSize * (long)block;
            DBFDataType usedType = type;
            file = new RandomAccessFile(this.memoFile, "r");
            file.seek(blockStart);
            byte[] blockData = new byte[this.blockSize];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.blockSize);
            boolean end = false;
            int itemSize = Integer.MAX_VALUE;
            boolean firstBlock = true;
            boolean checkForEndMark = true;
            block5: while (!end && (endIndex = file.read(blockData)) > 0) {
                int initialIndex = 0;
                if (firstBlock && (this.isFPT() || this.isMagicDBase4(blockData))) {
                    initialIndex = 8;
                    checkForEndMark = false;
                    if (this.isFPT()) {
                        byte intType = blockData[3];
                        if (intType == 1) {
                            usedType = DBFDataType.MEMO;
                        } else if (intType == 2) {
                            usedType = DBFDataType.BINARY;
                        } else if (intType == 0) {
                            usedType = DBFDataType.PICTURE;
                        }
                        itemSize = ByteBuffer.wrap(new byte[]{blockData[4], blockData[5], blockData[6], blockData[7]}).getInt();
                    } else {
                        itemSize = ByteBuffer.wrap(new byte[]{blockData[7], blockData[6], blockData[5], blockData[4]}).getInt() - 8;
                    }
                    endIndex = Math.min(itemSize + 8, endIndex);
                }
                firstBlock = false;
                for (int i = initialIndex; i < endIndex && baos.size() < itemSize; ++i) {
                    baos.write(blockData[i]);
                    if (checkForEndMark && i < endIndex - 2 && blockData[i + 1] == 26 && blockData[i + 2] == 26) {
                        end = true;
                        continue block5;
                    }
                    if (checkForEndMark) continue;
                    end = baos.size() >= itemSize;
                }
            }
            data = baos.toByteArray();
            if (usedType == DBFDataType.MEMO) break block16;
            byte[] byArray = data;
            DBFUtils.close(file);
            return byArray;
        }
        try {
            string = new String(data, this.charset);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                DBFUtils.close(file);
                throw throwable;
            }
        }
        DBFUtils.close(file);
        return string;
    }

    private boolean isMagicDBase4(byte[] blockData) {
        return blockData[0] == -1 && blockData[1] == -1 && blockData[2] == 8 && blockData[3] == 0;
    }
}

